/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.influx;

import com.google.common.base.Strings;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.influx.InfluxDbProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={InfluxDB.class})
@EnableConfigurationProperties(value={InfluxDbProperties.class})
public class InfluxDbAutoConfiguration {
    private final InfluxDbProperties properties;

    public InfluxDbAutoConfiguration(InfluxDbProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.influx.url"})
    public InfluxDB influxDb() {
        if (Strings.isNullOrEmpty((String)this.properties.getUser())) {
            return InfluxDBFactory.connect((String)this.properties.getUrl());
        }
        return InfluxDBFactory.connect((String)this.properties.getUrl(), (String)this.properties.getUser(), (String)this.properties.getPassword());
    }
}

