/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jooq.SQLDialect;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

final class SqlDialectLookup {
    private static final Log logger = LogFactory.getLog(SqlDialectLookup.class);
    private static final Map<DatabaseDriver, SQLDialect> LOOKUP;

    private SqlDialectLookup() {
    }

    public static SQLDialect getDialect(DataSource dataSource) {
        if (dataSource == null) {
            return SQLDialect.DEFAULT;
        }
        try {
            String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getURL");
            DatabaseDriver driver = DatabaseDriver.fromJdbcUrl((String)url);
            SQLDialect sqlDialect = LOOKUP.get(driver);
            if (sqlDialect != null) {
                return sqlDialect;
            }
        }
        catch (MetaDataAccessException ex) {
            logger.warn((Object)"Unable to determine jdbc url from datasource", (Throwable)ex);
        }
        return SQLDialect.DEFAULT;
    }

    static {
        HashMap<DatabaseDriver, SQLDialect> map = new HashMap<DatabaseDriver, SQLDialect>();
        map.put(DatabaseDriver.DERBY, SQLDialect.DERBY);
        map.put(DatabaseDriver.H2, SQLDialect.H2);
        map.put(DatabaseDriver.HSQLDB, SQLDialect.HSQLDB);
        map.put(DatabaseDriver.MARIADB, SQLDialect.MARIADB);
        map.put(DatabaseDriver.MYSQL, SQLDialect.MYSQL);
        map.put(DatabaseDriver.POSTGRESQL, SQLDialect.POSTGRES);
        map.put(DatabaseDriver.SQLITE, SQLDialect.SQLITE);
        LOOKUP = Collections.unmodifiableMap(map);
    }
}

