/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.reactive;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.userdetails.MapUserDetailsRepository;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsRepository;

@Configuration
@ConditionalOnClass(value={ReactiveAuthenticationManager.class})
@ConditionalOnMissingBean(value={ReactiveAuthenticationManager.class, UserDetailsRepository.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class ReactiveAuthenticationManagerConfiguration {
    private static final Log logger = LogFactory.getLog(ReactiveAuthenticationManagerConfiguration.class);

    @Bean
    public MapUserDetailsRepository userDetailsRepository() {
        String password = UUID.randomUUID().toString();
        logger.info((Object)String.format("%n%nUsing default security password: %s%n", password));
        UserDetails user = User.withUsername((String)"user").password(password).roles(new String[0]).build();
        return new MapUserDetailsRepository(new UserDetails[]{user});
    }
}

