/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.kafka;

import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.config.ContainerProperties;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;

public class ConcurrentKafkaListenerContainerFactoryConfigurer {
    private KafkaProperties properties;
    private RecordMessageConverter messageConverter;
    private KafkaTemplate<Object, Object> replyTemplate;

    void setKafkaProperties(KafkaProperties properties) {
        this.properties = properties;
    }

    void setMessageConverter(RecordMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setReplyTemplate(KafkaTemplate<Object, Object> replyTemplate) {
        this.replyTemplate = replyTemplate;
    }

    public void configure(ConcurrentKafkaListenerContainerFactory<Object, Object> listenerContainerFactory, ConsumerFactory<Object, Object> consumerFactory) {
        listenerContainerFactory.setConsumerFactory(consumerFactory);
        if (this.messageConverter != null) {
            listenerContainerFactory.setMessageConverter((MessageConverter)this.messageConverter);
        }
        if (this.replyTemplate != null) {
            listenerContainerFactory.setReplyTemplate(this.replyTemplate);
        }
        KafkaProperties.Listener container = this.properties.getListener();
        ContainerProperties containerProperties = listenerContainerFactory.getContainerProperties();
        if (container.getAckMode() != null) {
            containerProperties.setAckMode(container.getAckMode());
        }
        if (container.getAckCount() != null) {
            containerProperties.setAckCount(container.getAckCount().intValue());
        }
        if (container.getAckTime() != null) {
            containerProperties.setAckTime(container.getAckTime().longValue());
        }
        if (container.getPollTimeout() != null) {
            containerProperties.setPollTimeout(container.getPollTimeout().longValue());
        }
        if (container.getConcurrency() != null) {
            listenerContainerFactory.setConcurrency(container.getConcurrency());
        }
        if (container.getType() == KafkaProperties.Listener.Type.BATCH) {
            listenerContainerFactory.setBatchListener(Boolean.valueOf(true));
        }
    }
}

