/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateDefaultDdlAutoProvider;
import org.springframework.boot.autoconfigure.orm.jpa.JpaBaseConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.jdbc.SchemaManagementProvider;
import org.springframework.boot.jdbc.metadata.CompositeDataSourcePoolMetadataProvider;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.orm.jpa.hibernate.SpringJtaPlatform;
import org.springframework.context.annotation.Configuration;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnSingleCandidate(value=DataSource.class)
class HibernateJpaConfiguration
extends JpaBaseConfiguration {
    private static final Log logger = LogFactory.getLog(HibernateJpaConfiguration.class);
    private static final String JTA_PLATFORM = "hibernate.transaction.jta.platform";
    private static final String PROVIDER_DISABLES_AUTOCOMMIT = "hibernate.connection.provider_disables_autocommit";
    private static final String[] NO_JTA_PLATFORM_CLASSES = new String[]{"org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform", "org.hibernate.service.jta.platform.internal.NoJtaPlatform"};
    private static final String[] WEBSPHERE_JTA_PLATFORM_CLASSES = new String[]{"org.hibernate.engine.transaction.jta.platform.internal.WebSphereExtendedJtaPlatform", "org.hibernate.service.jta.platform.internal.WebSphereExtendedJtaPlatform"};
    private final HibernateDefaultDdlAutoProvider defaultDdlAutoProvider;
    private DataSourcePoolMetadataProvider poolMetadataProvider;

    HibernateJpaConfiguration(DataSource dataSource, JpaProperties jpaProperties, ObjectProvider<JtaTransactionManager> jtaTransactionManager, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers, ObjectProvider<Collection<DataSourcePoolMetadataProvider>> metadataProviders, ObjectProvider<List<SchemaManagementProvider>> providers) {
        super(dataSource, jpaProperties, jtaTransactionManager, transactionManagerCustomizers);
        this.defaultDdlAutoProvider = new HibernateDefaultDdlAutoProvider((List)providers.getIfAvailable(Collections::emptyList));
        this.poolMetadataProvider = new CompositeDataSourcePoolMetadataProvider((Collection)metadataProviders.getIfAvailable());
    }

    @Override
    protected AbstractJpaVendorAdapter createJpaVendorAdapter() {
        return new HibernateJpaVendorAdapter();
    }

    @Override
    protected Map<String, Object> getVendorProperties() {
        LinkedHashMap<String, Object> vendorProperties = new LinkedHashMap<String, Object>();
        String defaultDdlMode = this.defaultDdlAutoProvider.getDefaultDdlAuto(this.getDataSource());
        vendorProperties.putAll(this.getProperties().getHibernateProperties(defaultDdlMode));
        return vendorProperties;
    }

    @Override
    protected void customizeVendorProperties(Map<String, Object> vendorProperties) {
        super.customizeVendorProperties(vendorProperties);
        if (!vendorProperties.containsKey(JTA_PLATFORM)) {
            this.configureJtaPlatform(vendorProperties);
        }
        if (!vendorProperties.containsKey(PROVIDER_DISABLES_AUTOCOMMIT)) {
            this.configureProviderDisablesAutocommit(vendorProperties);
        }
    }

    private void configureJtaPlatform(Map<String, Object> vendorProperties) throws LinkageError {
        JtaTransactionManager jtaTransactionManager = this.getJtaTransactionManager();
        if (jtaTransactionManager != null) {
            if (this.runningOnWebSphere()) {
                this.configureWebSphereTransactionPlatform(vendorProperties);
            } else {
                this.configureSpringJtaPlatform(vendorProperties, jtaTransactionManager);
            }
        } else {
            vendorProperties.put(JTA_PLATFORM, this.getNoJtaPlatformManager());
        }
    }

    private void configureProviderDisablesAutocommit(Map<String, Object> vendorProperties) {
        if (this.isDataSourceAutoCommitDisabled() && !this.isJta()) {
            vendorProperties.put(PROVIDER_DISABLES_AUTOCOMMIT, "true");
        }
    }

    private boolean isDataSourceAutoCommitDisabled() {
        DataSourcePoolMetadata poolMetadata = this.poolMetadataProvider.getDataSourcePoolMetadata(this.getDataSource());
        return poolMetadata != null && Boolean.FALSE.equals(poolMetadata.getDefaultAutoCommit());
    }

    private boolean runningOnWebSphere() {
        return ClassUtils.isPresent((String)"com.ibm.websphere.jtaextensions.ExtendedJTATransaction", (ClassLoader)this.getClass().getClassLoader());
    }

    private void configureWebSphereTransactionPlatform(Map<String, Object> vendorProperties) {
        vendorProperties.put(JTA_PLATFORM, this.getWebSphereJtaPlatformManager());
    }

    private Object getWebSphereJtaPlatformManager() {
        return this.getJtaPlatformManager(WEBSPHERE_JTA_PLATFORM_CLASSES);
    }

    private void configureSpringJtaPlatform(Map<String, Object> vendorProperties, JtaTransactionManager jtaTransactionManager) {
        block3: {
            try {
                vendorProperties.put(JTA_PLATFORM, new SpringJtaPlatform(jtaTransactionManager));
            }
            catch (LinkageError ex) {
                if (!this.isUsingJndi()) {
                    throw new IllegalStateException("Unable to set Hibernate JTA platform, are you using the correct version of Hibernate?", ex);
                }
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Unable to set Hibernate JTA platform : " + ex.getMessage()));
            }
        }
    }

    private boolean isUsingJndi() {
        try {
            return JndiLocatorDelegate.isDefaultJndiEnvironmentAvailable();
        }
        catch (Error ex) {
            return false;
        }
    }

    private Object getNoJtaPlatformManager() {
        return this.getJtaPlatformManager(NO_JTA_PLATFORM_CLASSES);
    }

    private Object getJtaPlatformManager(String[] candidates) {
        for (String candidate : candidates) {
            try {
                return Class.forName(candidate).newInstance();
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException("Could not configure JTA platform");
    }
}

