/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;

@Configuration
@ConditionalOnBean(value={ObjectPostProcessor.class})
@ConditionalOnMissingBean(value={AuthenticationManager.class, AuthenticationProvider.class, UserDetailsService.class})
@Order(value=0)
public class AuthenticationManagerConfiguration {
    private static final Log logger = LogFactory.getLog(AuthenticationManagerConfiguration.class);

    @Bean
    public InMemoryUserDetailsManager inMemoryUserDetailsManager(ObjectProvider<PasswordEncoder> passwordEncoder) throws Exception {
        String password = UUID.randomUUID().toString();
        logger.info((Object)String.format("%n%nUsing default security password: %s%n", password));
        String encodedPassword = ((PasswordEncoder)passwordEncoder.getIfAvailable(PasswordEncoderFactories::createDelegatingPasswordEncoder)).encode((CharSequence)password);
        return new InMemoryUserDetailsManager(new UserDetails[]{User.withUsername((String)"user").password(encodedPassword).roles(new String[0]).build()});
    }
}

