/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import io.undertow.UndertowOptions;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.boot.web.servlet.server.InitParameterConfiguringServletContextInitializer;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>,
EnvironmentAware,
Ordered {
    private final ServerProperties serverProperties;
    private Environment environment;

    public DefaultServletWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setLoader(String value) {
    }

    public int getOrder() {
        return 0;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        if (this.serverProperties.getPort() != null) {
            factory.setPort(this.serverProperties.getPort().intValue());
        }
        if (this.serverProperties.getAddress() != null) {
            factory.setAddress(this.serverProperties.getAddress());
        }
        if (this.serverProperties.getServlet().getContextPath() != null) {
            factory.setContextPath(this.serverProperties.getServlet().getContextPath());
        }
        if (this.serverProperties.getDisplayName() != null) {
            factory.setDisplayName(this.serverProperties.getDisplayName());
        }
        if (this.serverProperties.getSession().getTimeout() != null) {
            factory.setSessionTimeout(this.serverProperties.getSession().getTimeout());
        }
        factory.setPersistSession(this.serverProperties.getSession().isPersistent());
        factory.setSessionStoreDir(this.serverProperties.getSession().getStoreDir());
        if (this.serverProperties.getSsl() != null) {
            factory.setSsl(this.serverProperties.getSsl());
        }
        if (this.serverProperties.getServlet() != null) {
            factory.setJsp(this.serverProperties.getServlet().getJsp());
        }
        if (this.serverProperties.getCompression() != null) {
            factory.setCompression(this.serverProperties.getCompression());
        }
        if (this.serverProperties.getHttp2() != null) {
            factory.setHttp2(this.serverProperties.getHttp2());
        }
        factory.setServerHeader(this.serverProperties.getServerHeader());
        if (factory instanceof TomcatServletWebServerFactory) {
            TomcatCustomizer.customizeTomcat(this.serverProperties, this.environment, (TomcatServletWebServerFactory)factory);
        }
        if (factory instanceof JettyServletWebServerFactory) {
            JettyCustomizer.customizeJetty(this.serverProperties, this.environment, (JettyServletWebServerFactory)factory);
        }
        if (factory instanceof UndertowServletWebServerFactory) {
            UndertowCustomizer.customizeUndertow(this.serverProperties, this.environment, (UndertowServletWebServerFactory)factory);
        }
        factory.addInitializers(new ServletContextInitializer[]{new SessionConfiguringInitializer(this.serverProperties.getSession())});
        factory.addInitializers(new ServletContextInitializer[]{new InitParameterConfiguringServletContextInitializer(this.serverProperties.getServlet().getContextParameters())});
    }

    private static boolean getOrDeduceUseForwardHeaders(ServerProperties serverProperties, Environment environment) {
        if (serverProperties.isUseForwardHeaders() != null) {
            return serverProperties.isUseForwardHeaders();
        }
        CloudPlatform platform = CloudPlatform.getActive((Environment)environment);
        return platform == null ? false : platform.isUsingForwardHeaders();
    }

    private static class JettyCustomizer {
        private JettyCustomizer() {
        }

        public static void customizeJetty(ServerProperties serverProperties, Environment environment, JettyServletWebServerFactory factory) {
            ServerProperties.Jetty jettyProperties = serverProperties.getJetty();
            factory.setUseForwardHeaders(DefaultServletWebServerFactoryCustomizer.getOrDeduceUseForwardHeaders(serverProperties, environment));
            if (jettyProperties.getAcceptors() != null) {
                factory.setAcceptors(jettyProperties.getAcceptors().intValue());
            }
            if (jettyProperties.getSelectors() != null) {
                factory.setSelectors(jettyProperties.getSelectors().intValue());
            }
            if (serverProperties.getMaxHttpHeaderSize() > 0) {
                JettyCustomizer.customizeMaxHttpHeaderSize(factory, serverProperties.getMaxHttpHeaderSize());
            }
            if (jettyProperties.getMaxHttpPostSize() > 0) {
                JettyCustomizer.customizeMaxHttpPostSize(factory, jettyProperties.getMaxHttpPostSize());
            }
            if (serverProperties.getConnectionTimeout() != null) {
                JettyCustomizer.customizeConnectionTimeout(factory, serverProperties.getConnectionTimeout());
            }
            if (jettyProperties.getAccesslog().isEnabled()) {
                JettyCustomizer.customizeAccessLog(factory, jettyProperties.getAccesslog());
            }
        }

        private static void customizeConnectionTimeout(JettyServletWebServerFactory factory, Duration connectionTimeout) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{server -> {
                for (Connector connector : server.getConnectors()) {
                    if (!(connector instanceof AbstractConnector)) continue;
                    ((AbstractConnector)connector).setIdleTimeout(connectionTimeout.toMillis());
                }
            }});
        }

        private static void customizeMaxHttpHeaderSize(JettyServletWebServerFactory factory, final int maxHttpHeaderSize) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

                public void customize(Server server) {
                    for (Connector connector : server.getConnectors()) {
                        try {
                            for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                                if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory)) continue;
                                this.customize((HttpConfiguration.ConnectionFactory)connectionFactory);
                            }
                        }
                        catch (NoSuchMethodError ex) {
                            this.customizeOnJetty8(connector, maxHttpHeaderSize);
                        }
                    }
                }

                private void customize(HttpConfiguration.ConnectionFactory factory) {
                    HttpConfiguration configuration = factory.getHttpConfiguration();
                    configuration.setRequestHeaderSize(maxHttpHeaderSize);
                    configuration.setResponseHeaderSize(maxHttpHeaderSize);
                }

                private void customizeOnJetty8(Connector connector, int maxHttpHeaderSize2) {
                    try {
                        connector.getClass().getMethod("setRequestHeaderSize", Integer.TYPE).invoke((Object)connector, maxHttpHeaderSize2);
                        connector.getClass().getMethod("setResponseHeaderSize", Integer.TYPE).invoke((Object)connector, maxHttpHeaderSize2);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }});
        }

        private static void customizeMaxHttpPostSize(JettyServletWebServerFactory factory, final int maxHttpPostSize) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

                public void customize(Server server) {
                    this.setHandlerMaxHttpPostSize(maxHttpPostSize, server.getHandlers());
                }

                private void setHandlerMaxHttpPostSize(int maxHttpPostSize2, Handler ... handlers) {
                    for (Handler handler : handlers) {
                        if (handler instanceof ContextHandler) {
                            ((ContextHandler)handler).setMaxFormContentSize(maxHttpPostSize2);
                            continue;
                        }
                        if (handler instanceof HandlerWrapper) {
                            this.setHandlerMaxHttpPostSize(maxHttpPostSize2, ((HandlerWrapper)handler).getHandler());
                            continue;
                        }
                        if (!(handler instanceof HandlerCollection)) continue;
                        this.setHandlerMaxHttpPostSize(maxHttpPostSize2, ((HandlerCollection)handler).getHandlers());
                    }
                }
            }});
        }

        private static void customizeAccessLog(JettyServletWebServerFactory factory, ServerProperties.Jetty.Accesslog properties) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{server -> {
                NCSARequestLog log = new NCSARequestLog();
                if (properties.getFilename() != null) {
                    log.setFilename(properties.getFilename());
                }
                if (properties.getFileDateFormat() != null) {
                    log.setFilenameDateFormat(properties.getFileDateFormat());
                }
                log.setRetainDays(properties.getRetentionPeriod());
                log.setAppend(properties.isAppend());
                log.setExtended(properties.isExtendedFormat());
                if (properties.getDateFormat() != null) {
                    log.setLogDateFormat(properties.getDateFormat());
                }
                if (properties.getLocale() != null) {
                    log.setLogLocale(properties.getLocale());
                }
                if (properties.getTimeZone() != null) {
                    log.setLogTimeZone(properties.getTimeZone().getID());
                }
                log.setLogCookies(properties.isLogCookies());
                log.setLogServer(properties.isLogServer());
                log.setLogLatency(properties.isLogLatency());
                server.setRequestLog((RequestLog)log);
            }});
        }
    }

    private static class UndertowCustomizer {
        private UndertowCustomizer() {
        }

        protected static void customizeUndertow(ServerProperties serverProperties, Environment environment, UndertowServletWebServerFactory factory) {
            ServerProperties.Undertow undertowProperties = serverProperties.getUndertow();
            ServerProperties.Undertow.Accesslog accesslogProperties = undertowProperties.getAccesslog();
            if (undertowProperties.getBufferSize() != null) {
                factory.setBufferSize(undertowProperties.getBufferSize());
            }
            if (undertowProperties.getIoThreads() != null) {
                factory.setIoThreads(undertowProperties.getIoThreads());
            }
            if (undertowProperties.getWorkerThreads() != null) {
                factory.setWorkerThreads(undertowProperties.getWorkerThreads());
            }
            if (undertowProperties.getDirectBuffers() != null) {
                factory.setDirectBuffers(undertowProperties.getDirectBuffers());
            }
            if (undertowProperties.getAccesslog().getEnabled() != null) {
                factory.setAccessLogEnabled(accesslogProperties.getEnabled().booleanValue());
            }
            factory.setAccessLogDirectory(accesslogProperties.getDir());
            factory.setAccessLogPattern(accesslogProperties.getPattern());
            factory.setAccessLogPrefix(accesslogProperties.getPrefix());
            factory.setAccessLogSuffix(accesslogProperties.getSuffix());
            factory.setAccessLogRotate(accesslogProperties.isRotate());
            factory.setUseForwardHeaders(DefaultServletWebServerFactoryCustomizer.getOrDeduceUseForwardHeaders(serverProperties, environment));
            if (serverProperties.getMaxHttpHeaderSize() > 0) {
                UndertowCustomizer.customizeMaxHttpHeaderSize(factory, serverProperties.getMaxHttpHeaderSize());
            }
            if (undertowProperties.getMaxHttpPostSize() > 0L) {
                UndertowCustomizer.customizeMaxHttpPostSize(factory, undertowProperties.getMaxHttpPostSize());
            }
            if (serverProperties.getConnectionTimeout() != null) {
                UndertowCustomizer.customizeConnectionTimeout(factory, serverProperties.getConnectionTimeout());
            }
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> deploymentInfo.setEagerFilterInit(undertowProperties.isEagerFilterInit())});
        }

        private static void customizeConnectionTimeout(UndertowServletWebServerFactory factory, Duration connectionTimeout) {
            factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setSocketOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)((int)connectionTimeout.toMillis()))});
        }

        private static void customizeMaxHttpHeaderSize(UndertowServletWebServerFactory factory, int maxHttpHeaderSize) {
            factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(UndertowOptions.MAX_HEADER_SIZE, (Object)maxHttpHeaderSize)});
        }

        private static void customizeMaxHttpPostSize(UndertowServletWebServerFactory factory, long maxHttpPostSize) {
            factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)maxHttpPostSize)});
        }
    }

    private static class TomcatCustomizer {
        private TomcatCustomizer() {
        }

        public static void customizeTomcat(ServerProperties serverProperties, Environment environment, TomcatServletWebServerFactory factory) {
            int maxHttpHeaderSize;
            ServerProperties.Tomcat tomcatProperties = serverProperties.getTomcat();
            if (tomcatProperties.getBasedir() != null) {
                factory.setBaseDirectory(tomcatProperties.getBasedir());
            }
            if (tomcatProperties.getBackgroundProcessorDelay() != null) {
                factory.setBackgroundProcessorDelay((int)tomcatProperties.getBackgroundProcessorDelay().getSeconds());
            }
            TomcatCustomizer.customizeRemoteIpValve(serverProperties, environment, factory);
            if (tomcatProperties.getMaxThreads() > 0) {
                TomcatCustomizer.customizeMaxThreads(factory, tomcatProperties.getMaxThreads());
            }
            if (tomcatProperties.getMinSpareThreads() > 0) {
                TomcatCustomizer.customizeMinThreads(factory, tomcatProperties.getMinSpareThreads());
            }
            int n = maxHttpHeaderSize = serverProperties.getMaxHttpHeaderSize() > 0 ? serverProperties.getMaxHttpHeaderSize() : tomcatProperties.getMaxHttpHeaderSize();
            if (maxHttpHeaderSize > 0) {
                TomcatCustomizer.customizeMaxHttpHeaderSize(factory, maxHttpHeaderSize);
            }
            if (tomcatProperties.getMaxHttpPostSize() != 0) {
                TomcatCustomizer.customizeMaxHttpPostSize(factory, tomcatProperties.getMaxHttpPostSize());
            }
            if (tomcatProperties.getAccesslog().isEnabled()) {
                TomcatCustomizer.customizeAccessLog(tomcatProperties, factory);
            }
            if (tomcatProperties.getUriEncoding() != null) {
                factory.setUriEncoding(tomcatProperties.getUriEncoding());
            }
            if (serverProperties.getConnectionTimeout() != null) {
                TomcatCustomizer.customizeConnectionTimeout(factory, serverProperties.getConnectionTimeout());
            }
            if (tomcatProperties.getRedirectContextRoot() != null) {
                TomcatCustomizer.customizeRedirectContextRoot(factory, tomcatProperties.getRedirectContextRoot());
            }
            if (tomcatProperties.getMaxConnections() > 0) {
                TomcatCustomizer.customizeMaxConnections(factory, tomcatProperties.getMaxConnections());
            }
            if (tomcatProperties.getAcceptCount() > 0) {
                TomcatCustomizer.customizeAcceptCount(factory, tomcatProperties.getAcceptCount());
            }
            if (!ObjectUtils.isEmpty(tomcatProperties.getAdditionalTldSkipPatterns())) {
                factory.getTldSkipPatterns().addAll(tomcatProperties.getAdditionalTldSkipPatterns());
            }
            TomcatCustomizer.customizeStaticResources(serverProperties.getTomcat().getResource(), factory);
        }

        private static void customizeAcceptCount(TomcatServletWebServerFactory factory, int acceptCount) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractProtocol) {
                    AbstractProtocol protocol = (AbstractProtocol)handler;
                    protocol.setAcceptCount(acceptCount);
                }
            }});
        }

        private static void customizeMaxConnections(TomcatServletWebServerFactory factory, int maxConnections) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractProtocol) {
                    AbstractProtocol protocol = (AbstractProtocol)handler;
                    protocol.setMaxConnections(maxConnections);
                }
            }});
        }

        private static void customizeConnectionTimeout(TomcatServletWebServerFactory factory, Duration connectionTimeout) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractProtocol) {
                    AbstractProtocol protocol = (AbstractProtocol)handler;
                    protocol.setConnectionTimeout((int)connectionTimeout.toMillis());
                }
            }});
        }

        private static void customizeRemoteIpValve(ServerProperties properties, Environment environment, TomcatServletWebServerFactory factory) {
            String protocolHeader = properties.getTomcat().getProtocolHeader();
            String remoteIpHeader = properties.getTomcat().getRemoteIpHeader();
            if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || DefaultServletWebServerFactoryCustomizer.getOrDeduceUseForwardHeaders(properties, environment)) {
                RemoteIpValve valve = new RemoteIpValve();
                valve.setProtocolHeader(StringUtils.hasLength((String)protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
                if (StringUtils.hasLength((String)remoteIpHeader)) {
                    valve.setRemoteIpHeader(remoteIpHeader);
                }
                valve.setInternalProxies(properties.getTomcat().getInternalProxies());
                valve.setPortHeader(properties.getTomcat().getPortHeader());
                valve.setProtocolHeaderHttpsValue(properties.getTomcat().getProtocolHeaderHttpsValue());
                factory.addEngineValves(new Valve[]{valve});
            }
        }

        private static void customizeMaxThreads(TomcatServletWebServerFactory factory, int maxThreads) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractProtocol) {
                    AbstractProtocol protocol = (AbstractProtocol)handler;
                    protocol.setMaxThreads(maxThreads);
                }
            }});
        }

        private static void customizeMinThreads(TomcatServletWebServerFactory factory, int minSpareThreads) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractProtocol) {
                    AbstractProtocol protocol = (AbstractProtocol)handler;
                    protocol.setMinSpareThreads(minSpareThreads);
                }
            }});
        }

        private static void customizeMaxHttpHeaderSize(TomcatServletWebServerFactory factory, int maxHttpHeaderSize) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                ProtocolHandler handler = connector.getProtocolHandler();
                if (handler instanceof AbstractHttp11Protocol) {
                    AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                    protocol.setMaxHttpHeaderSize(maxHttpHeaderSize);
                }
            }});
        }

        private static void customizeMaxHttpPostSize(TomcatServletWebServerFactory factory, int maxHttpPostSize) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> connector.setMaxPostSize(maxHttpPostSize)});
        }

        private static void customizeAccessLog(ServerProperties.Tomcat tomcatProperties, TomcatServletWebServerFactory factory) {
            AccessLogValve valve = new AccessLogValve();
            valve.setPattern(tomcatProperties.getAccesslog().getPattern());
            valve.setDirectory(tomcatProperties.getAccesslog().getDirectory());
            valve.setPrefix(tomcatProperties.getAccesslog().getPrefix());
            valve.setSuffix(tomcatProperties.getAccesslog().getSuffix());
            valve.setRenameOnRotate(tomcatProperties.getAccesslog().isRenameOnRotate());
            valve.setFileDateFormat(tomcatProperties.getAccesslog().getFileDateFormat());
            valve.setRequestAttributesEnabled(tomcatProperties.getAccesslog().isRequestAttributesEnabled());
            valve.setRotatable(tomcatProperties.getAccesslog().isRotate());
            valve.setBuffered(tomcatProperties.getAccesslog().isBuffered());
            factory.addEngineValves(new Valve[]{valve});
        }

        private static void customizeRedirectContextRoot(TomcatServletWebServerFactory factory, boolean redirectContextRoot) {
            factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.setMapperContextRootRedirectEnabled(redirectContextRoot)});
        }

        private static void customizeStaticResources(ServerProperties.Tomcat.Resource resource, TomcatServletWebServerFactory factory) {
            if (resource.getCacheTtl() == null) {
                return;
            }
            factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.addLifecycleListener(event -> {
                if (event.getType().equals("configure_start")) {
                    long ttl = resource.getCacheTtl().toMillis();
                    context.getResources().setCacheTtl(ttl);
                }
            })});
        }
    }

    private static class SessionConfiguringInitializer
    implements ServletContextInitializer {
        private final ServerProperties.Session session;

        SessionConfiguringInitializer(ServerProperties.Session session) {
            this.session = session;
        }

        public void onStartup(ServletContext servletContext) throws ServletException {
            if (this.session.getTrackingModes() != null) {
                servletContext.setSessionTrackingModes(this.unwrap(this.session.getTrackingModes()));
            }
            this.configureSessionCookie(servletContext.getSessionCookieConfig());
        }

        private void configureSessionCookie(SessionCookieConfig config) {
            ServerProperties.Session.Cookie cookie = this.session.getCookie();
            if (cookie.getName() != null) {
                config.setName(cookie.getName());
            }
            if (cookie.getDomain() != null) {
                config.setDomain(cookie.getDomain());
            }
            if (cookie.getPath() != null) {
                config.setPath(cookie.getPath());
            }
            if (cookie.getComment() != null) {
                config.setComment(cookie.getComment());
            }
            if (cookie.getHttpOnly() != null) {
                config.setHttpOnly(cookie.getHttpOnly().booleanValue());
            }
            if (cookie.getSecure() != null) {
                config.setSecure(cookie.getSecure().booleanValue());
            }
            if (cookie.getMaxAge() != null) {
                config.setMaxAge((int)cookie.getMaxAge().getSeconds());
            }
        }

        private Set<SessionTrackingMode> unwrap(Set<ServerProperties.Session.SessionTrackingMode> modes) {
            if (modes == null) {
                return null;
            }
            LinkedHashSet<SessionTrackingMode> result = new LinkedHashSet<SessionTrackingMode>();
            for (ServerProperties.Session.SessionTrackingMode mode : modes) {
                result.add(SessionTrackingMode.valueOf((String)mode.name()));
            }
            return result;
        }
    }
}

