/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.session.HazelcastSessionConfiguration;
import org.springframework.boot.autoconfigure.session.JdbcSessionConfiguration;
import org.springframework.boot.autoconfigure.session.MongoReactiveSessionConfiguration;
import org.springframework.boot.autoconfigure.session.MongoSessionConfiguration;
import org.springframework.boot.autoconfigure.session.NoOpReactiveSessionConfiguration;
import org.springframework.boot.autoconfigure.session.NoOpSessionConfiguration;
import org.springframework.boot.autoconfigure.session.RedisReactiveSessionConfiguration;
import org.springframework.boot.autoconfigure.session.RedisSessionConfiguration;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.util.Assert;

final class SessionStoreMappings {
    private static final Map<StoreType, Map<WebApplicationType, Class<?>>> MAPPINGS;

    static Map<WebApplicationType, Class<?>> createMapping(Class<?> servletConfiguration) {
        return SessionStoreMappings.createMapping(servletConfiguration, null);
    }

    static Map<WebApplicationType, Class<?>> createMapping(Class<?> servletConfiguration, Class<?> reactiveConfiguration) {
        EnumMap mapping = new EnumMap(WebApplicationType.class);
        mapping.put(WebApplicationType.SERVLET, servletConfiguration);
        if (reactiveConfiguration != null) {
            mapping.put(WebApplicationType.REACTIVE, reactiveConfiguration);
        }
        return mapping;
    }

    private SessionStoreMappings() {
    }

    static String getConfigurationClass(WebApplicationType webApplicationType, StoreType sessionStoreType) {
        Map<WebApplicationType, Class<?>> configurationClasses = MAPPINGS.get((Object)sessionStoreType);
        Assert.state((configurationClasses != null ? 1 : 0) != 0, () -> "Unknown session store type " + (Object)((Object)sessionStoreType));
        Class<?> configurationClass = configurationClasses.get(webApplicationType);
        if (configurationClass == null) {
            return null;
        }
        return configurationClass.getName();
    }

    static StoreType getType(WebApplicationType webApplicationType, String configurationClassName) {
        for (Map.Entry<StoreType, Map<WebApplicationType, Class<?>>> storeEntry : MAPPINGS.entrySet()) {
            for (Map.Entry<WebApplicationType, Class<?>> entry : storeEntry.getValue().entrySet()) {
                if (entry.getKey() != webApplicationType || !entry.getValue().getName().equals(configurationClassName)) continue;
                return storeEntry.getKey();
            }
        }
        throw new IllegalStateException("Unknown configuration class " + configurationClassName);
    }

    static {
        EnumMap mappings = new EnumMap(StoreType.class);
        mappings.put(StoreType.REDIS, SessionStoreMappings.createMapping(RedisSessionConfiguration.class, RedisReactiveSessionConfiguration.class));
        mappings.put(StoreType.MONGODB, SessionStoreMappings.createMapping(MongoSessionConfiguration.class, MongoReactiveSessionConfiguration.class));
        mappings.put(StoreType.JDBC, SessionStoreMappings.createMapping(JdbcSessionConfiguration.class));
        mappings.put(StoreType.HAZELCAST, SessionStoreMappings.createMapping(HazelcastSessionConfiguration.class));
        mappings.put(StoreType.NONE, SessionStoreMappings.createMapping(NoOpSessionConfiguration.class, NoOpReactiveSessionConfiguration.class));
        MAPPINGS = Collections.unmodifiableMap(mappings);
    }
}

