/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class OAuth2ClientPropertiesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Bindable<Map<String, OAuth2ClientProperties.LoginClientRegistration>> STRING_LEGACY_REGISTRATION_MAP = Bindable.mapOf(String.class, OAuth2ClientProperties.LoginClientRegistration.class);
    private static final String PREFIX = "spring.security.oauth2.client.registration";
    private static final String LOGIN_REGISTRATION_PREFIX = "spring.security.oauth2.client.registration.login.";
    private static final String UPDATED_PROPERTY_SOURCE_SUFFIX = "-updated-oauth-client";
    private int order = -2147483637;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        environment.getPropertySources().forEach(propertySource -> {
            String name = propertySource.getName();
            Iterable sources = ConfigurationPropertySources.from((PropertySource)propertySource);
            ConfigurationPropertySource source = (ConfigurationPropertySource)sources.iterator().next();
            Binder binder = new Binder(sources);
            LinkedHashMap map = new LinkedHashMap();
            MapPropertySource updatedPropertySource = new MapPropertySource(name + UPDATED_PROPERTY_SOURCE_SUFFIX, map);
            Map registrations = (Map)binder.bind(PREFIX, STRING_LEGACY_REGISTRATION_MAP).orElse(Collections.emptyMap());
            registrations.entrySet().forEach(entry -> this.addProperties((Map.Entry<String, OAuth2ClientProperties.LoginClientRegistration>)entry, source, map));
            if (!map.isEmpty()) {
                environment.getPropertySources().addBefore(name, (PropertySource)updatedPropertySource);
            }
        });
    }

    private void addProperties(Map.Entry<String, OAuth2ClientProperties.LoginClientRegistration> entry, ConfigurationPropertySource source, Map<String, Object> map) {
        OAuth2ClientProperties.LoginClientRegistration registration = entry.getValue();
        String registrationId = entry.getKey();
        this.addProperty(registrationId, "client-id", registration::getClientId, map, source);
        this.addProperty(registrationId, "client-secret", registration::getClientSecret, map, source);
        this.addProperty(registrationId, "client-name", registration::getClientName, map, source);
        this.addProperty(registrationId, "redirect-uri-template", registration::getRedirectUri, map, source);
        this.addProperty(registrationId, "authorization-grant-type", registration::getAuthorizationGrantType, map, source);
        this.addProperty(registrationId, "client-authentication-method", registration::getClientAuthenticationMethod, map, source);
        this.addProperty(registrationId, "provider", registration::getProvider, map, source);
        this.addProperty(registrationId, "scope", registration::getScope, map, source);
    }

    private void addProperty(String registrationId, String property, Supplier<Object> valueSupplier, Map<String, Object> map, ConfigurationPropertySource source) {
        String registrationKey = "spring.security.oauth2.client.registration." + registrationId + ".";
        String loginRegistrationKey = LOGIN_REGISTRATION_PREFIX + registrationId + ".";
        if (source.getConfigurationProperty(ConfigurationPropertyName.of((CharSequence)(registrationKey + property))) != null) {
            map.put(loginRegistrationKey + property, valueSupplier.get());
        }
    }

    public int getOrder() {
        return this.order;
    }
}

