/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.influx;

import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.influxdb.InfluxDB;
import org.influxdb.impl.InfluxDBImpl;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.influx.InfluxDbOkHttpClientBuilderProvider;
import org.springframework.boot.autoconfigure.influx.InfluxDbProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={InfluxDB.class})
@EnableConfigurationProperties(value={InfluxDbProperties.class})
public class InfluxDbAutoConfiguration {
    private static final Log logger = LogFactory.getLog(InfluxDbAutoConfiguration.class);
    private final InfluxDbProperties properties;
    private final OkHttpClient.Builder builder;

    public InfluxDbAutoConfiguration(InfluxDbProperties properties, ObjectProvider<InfluxDbOkHttpClientBuilderProvider> builder, ObjectProvider<OkHttpClient.Builder> deprecatedBuilder) {
        this.properties = properties;
        this.builder = InfluxDbAutoConfiguration.determineBuilder((InfluxDbOkHttpClientBuilderProvider)builder.getIfAvailable(), (OkHttpClient.Builder)deprecatedBuilder.getIfAvailable());
    }

    @Deprecated
    private static OkHttpClient.Builder determineBuilder(InfluxDbOkHttpClientBuilderProvider builder, OkHttpClient.Builder deprecatedBuilder) {
        if (builder != null) {
            return (OkHttpClient.Builder)builder.get();
        }
        if (deprecatedBuilder != null) {
            logger.warn((Object)("InfluxDB client customizations using a OkHttpClient.Builder is deprecated, register a " + InfluxDbOkHttpClientBuilderProvider.class.getSimpleName() + " bean instead"));
            return deprecatedBuilder;
        }
        return new OkHttpClient.Builder();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.influx.url"})
    public InfluxDB influxDb() {
        return new InfluxDBImpl(this.properties.getUrl(), this.properties.getUser(), this.properties.getPassword(), this.builder);
    }
}

