/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.jdbc;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jdbc.JdbcRepositoriesAutoConfigureRegistrar;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.jdbc.repository.config.AbstractJdbcConfiguration;
import org.springframework.data.jdbc.repository.config.JdbcConfiguration;
import org.springframework.data.jdbc.repository.config.JdbcRepositoryConfigExtension;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
@ConditionalOnBean(value={NamedParameterJdbcOperations.class})
@ConditionalOnClass(value={NamedParameterJdbcOperations.class, AbstractJdbcConfiguration.class})
@ConditionalOnProperty(prefix="spring.data.jdbc.repositories", name={"enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={JdbcTemplateAutoConfiguration.class})
public class JdbcRepositoriesAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={AbstractJdbcConfiguration.class, JdbcConfiguration.class})
    static class SpringBootJdbcConfiguration
    extends AbstractJdbcConfiguration {
        SpringBootJdbcConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={JdbcRepositoryConfigExtension.class})
    @Import(value={JdbcRepositoriesAutoConfigureRegistrar.class})
    static class JdbcRepositoriesConfiguration {
        JdbcRepositoriesConfiguration() {
        }
    }
}

