/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ldap;

import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ldap.LdapProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
@ConditionalOnClass(value={ContextSource.class})
@EnableConfigurationProperties(value={LdapProperties.class})
public class LdapAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LdapContextSource ldapContextSource(LdapProperties properties, Environment environment) {
        LdapContextSource source = new LdapContextSource();
        source.setUserDn(properties.getUsername());
        source.setPassword(properties.getPassword());
        source.setAnonymousReadOnly(properties.getAnonymousReadOnly());
        source.setBase(properties.getBase());
        source.setUrls(properties.determineUrls(environment));
        source.setBaseEnvironmentProperties(Collections.unmodifiableMap(properties.getBaseEnvironment()));
        return source;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapOperations.class})
    public LdapTemplate ldapTemplate(ContextSource contextSource) {
        return new LdapTemplate(contextSource);
    }
}

