/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.reactive;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.web.server.SecurityWebFilterChain;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={ReactiveJwtDecoder.class})
class ReactiveOAuth2ResourceServerWebSecurityConfiguration {
    ReactiveOAuth2ResourceServerWebSecurityConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http, ReactiveJwtDecoder jwtDecoder) {
        http.authorizeExchange().anyExchange().authenticated().and().oauth2ResourceServer().jwt().jwtDecoder(jwtDecoder);
        return http.build();
    }
}

