/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.BeanTypeRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.FilteringSpringBootCondition;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Order(value=0x7FFFFFFF)
class OnBeanCondition
extends FilteringSpringBootCondition
implements ConfigurationCondition {
    public static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";

    OnBeanCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    @Override
    protected final ConditionOutcome[] getOutcomes(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        ConditionOutcome[] outcomes = new ConditionOutcome[autoConfigurationClasses.length];
        for (int i = 0; i < outcomes.length; ++i) {
            String autoConfigurationClass = autoConfigurationClasses[i];
            if (autoConfigurationClass == null) continue;
            Set<String> onBeanTypes = autoConfigurationMetadata.getSet(autoConfigurationClass, "ConditionalOnBean");
            outcomes[i] = this.getOutcome(onBeanTypes, ConditionalOnBean.class);
            if (outcomes[i] != null) continue;
            Set<String> onSingleCandidateTypes = autoConfigurationMetadata.getSet(autoConfigurationClass, "ConditionalOnSingleCandidate");
            outcomes[i] = this.getOutcome(onSingleCandidateTypes, ConditionalOnSingleCandidate.class);
        }
        return outcomes;
    }

    private ConditionOutcome getOutcome(Set<String> requiredBeanTypes, Class<? extends Annotation> annotation) {
        List<String> missing = this.filter(requiredBeanTypes, FilteringSpringBootCondition.ClassNameFilter.MISSING, this.getBeanClassLoader());
        if (!missing.isEmpty()) {
            ConditionMessage message = ConditionMessage.forCondition(annotation, new Object[0]).didNotFind("required type", "required types").items(ConditionMessage.Style.QUOTE, missing);
            return ConditionOutcome.noMatch(message);
        }
        return null;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MatchResult matchResult;
        BeanSearchSpec spec;
        ConditionMessage matchMessage = ConditionMessage.empty();
        if (metadata.isAnnotated(ConditionalOnBean.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnBean.class);
            matchResult = this.getMatchingBeans(context, spec);
            if (!matchResult.isAllMatched()) {
                String reason = this.createOnBeanNoMatchReason(matchResult);
                return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnBean.class, spec).because(reason));
            }
            matchMessage = matchMessage.andCondition(ConditionalOnBean.class, spec).found("bean", "beans").items(ConditionMessage.Style.QUOTE, matchResult.getNamesOfAllMatches());
        }
        if (metadata.isAnnotated(ConditionalOnSingleCandidate.class.getName())) {
            spec = new SingleCandidateBeanSearchSpec(context, metadata, ConditionalOnSingleCandidate.class);
            matchResult = this.getMatchingBeans(context, spec);
            if (!matchResult.isAllMatched()) {
                return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnSingleCandidate.class, spec).didNotFind("any beans").atAll());
            }
            if (!this.hasSingleAutowireCandidate(context.getBeanFactory(), matchResult.getNamesOfAllMatches(), spec.getStrategy() == SearchStrategy.ALL)) {
                return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnSingleCandidate.class, spec).didNotFind("a primary bean from beans").items(ConditionMessage.Style.QUOTE, matchResult.getNamesOfAllMatches()));
            }
            matchMessage = matchMessage.andCondition(ConditionalOnSingleCandidate.class, spec).found("a primary bean from beans").items(ConditionMessage.Style.QUOTE, matchResult.getNamesOfAllMatches());
        }
        if (metadata.isAnnotated(ConditionalOnMissingBean.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnMissingBean.class);
            matchResult = this.getMatchingBeans(context, spec);
            if (matchResult.isAnyMatched()) {
                String reason = this.createOnMissingBeanNoMatchReason(matchResult);
                return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnMissingBean.class, spec).because(reason));
            }
            matchMessage = matchMessage.andCondition(ConditionalOnMissingBean.class, spec).didNotFind("any beans").atAll();
        }
        return ConditionOutcome.match(matchMessage);
    }

    protected final MatchResult getMatchingBeans(ConditionContext context, BeanSearchSpec beans) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beans.getStrategy() == SearchStrategy.ANCESTORS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)parent, (String)"Unable to use SearchStrategy.PARENTS");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        MatchResult matchResult = new MatchResult();
        boolean considerHierarchy = beans.getStrategy() != SearchStrategy.CURRENT;
        BeanTypeRegistry.TypeExtractor typeExtractor = beans.getTypeExtractor(context.getClassLoader());
        List<String> beansIgnoredByType = this.getNamesOfBeansIgnoredByType(beans.getIgnoredTypes(), typeExtractor, (ListableBeanFactory)beanFactory, context, considerHierarchy);
        for (String type : beans.getTypes()) {
            Collection<String> typeMatches = this.getBeanNamesForType((ListableBeanFactory)beanFactory, type, typeExtractor, context.getClassLoader(), considerHierarchy);
            typeMatches.removeAll(beansIgnoredByType);
            if (typeMatches.isEmpty()) {
                matchResult.recordUnmatchedType(type);
                continue;
            }
            matchResult.recordMatchedType(type, typeMatches);
        }
        for (String annotation : beans.getAnnotations()) {
            List<String> annotationMatches = Arrays.asList(this.getBeanNamesForAnnotation(beanFactory, annotation, context.getClassLoader(), considerHierarchy));
            annotationMatches.removeAll(beansIgnoredByType);
            if (annotationMatches.isEmpty()) {
                matchResult.recordUnmatchedAnnotation(annotation);
                continue;
            }
            matchResult.recordMatchedAnnotation(annotation, annotationMatches);
        }
        for (String beanName : beans.getNames()) {
            if (!beansIgnoredByType.contains(beanName) && this.containsBean(beanFactory, beanName, considerHierarchy)) {
                matchResult.recordMatchedName(beanName);
                continue;
            }
            matchResult.recordUnmatchedName(beanName);
        }
        return matchResult;
    }

    private String[] getBeanNamesForAnnotation(ConfigurableListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        HashSet<String> names = new HashSet<String>();
        try {
            Class annotationType = ClassUtils.forName((String)type, (ClassLoader)classLoader);
            this.collectBeanNamesForAnnotation(names, (ListableBeanFactory)beanFactory, annotationType, considerHierarchy);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return StringUtils.toStringArray(names);
    }

    private void collectBeanNamesForAnnotation(Set<String> names, ListableBeanFactory beanFactory, Class<? extends Annotation> annotationType, boolean considerHierarchy) {
        BeanFactory parent;
        BeanTypeRegistry registry = BeanTypeRegistry.get(beanFactory);
        names.addAll(registry.getNamesForAnnotation(annotationType));
        if (considerHierarchy && (parent = ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory()) instanceof ListableBeanFactory) {
            this.collectBeanNamesForAnnotation(names, (ListableBeanFactory)parent, annotationType, considerHierarchy);
        }
    }

    private List<String> getNamesOfBeansIgnoredByType(List<String> ignoredTypes, BeanTypeRegistry.TypeExtractor typeExtractor, ListableBeanFactory beanFactory, ConditionContext context, boolean considerHierarchy) {
        ArrayList<String> beanNames = new ArrayList<String>();
        for (String ignoredType : ignoredTypes) {
            beanNames.addAll(this.getBeanNamesForType(beanFactory, ignoredType, typeExtractor, context.getClassLoader(), considerHierarchy));
        }
        return beanNames;
    }

    private boolean containsBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (considerHierarchy) {
            return beanFactory.containsBean(beanName);
        }
        return beanFactory.containsLocalBean(beanName);
    }

    private Collection<String> getBeanNamesForType(ListableBeanFactory beanFactory, String type, BeanTypeRegistry.TypeExtractor typeExtractor, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        try {
            return this.getBeanNamesForType(beanFactory, considerHierarchy, ClassUtils.forName((String)type, (ClassLoader)classLoader), typeExtractor);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            return Collections.emptySet();
        }
    }

    private Collection<String> getBeanNamesForType(ListableBeanFactory beanFactory, boolean considerHierarchy, Class<?> type, BeanTypeRegistry.TypeExtractor typeExtractor) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.collectBeanNamesForType(result, beanFactory, type, typeExtractor, considerHierarchy);
        return result;
    }

    private void collectBeanNamesForType(Set<String> result, ListableBeanFactory beanFactory, Class<?> type, BeanTypeRegistry.TypeExtractor typeExtractor, boolean considerHierarchy) {
        BeanFactory parent;
        BeanTypeRegistry registry = BeanTypeRegistry.get(beanFactory);
        result.addAll(registry.getNamesForType(type, typeExtractor));
        if (considerHierarchy && beanFactory instanceof HierarchicalBeanFactory && (parent = ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory()) instanceof ListableBeanFactory) {
            this.collectBeanNamesForType(result, (ListableBeanFactory)parent, type, typeExtractor, considerHierarchy);
        }
    }

    private String createOnBeanNoMatchReason(MatchResult matchResult) {
        StringBuilder reason = new StringBuilder();
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedAnnotations(), "annotated with");
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedTypes(), "of type");
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedNames(), "named");
        return reason.toString();
    }

    private void appendMessageForNoMatches(StringBuilder reason, Collection<String> unmatched, String description) {
        if (!unmatched.isEmpty()) {
            if (reason.length() > 0) {
                reason.append(" and ");
            }
            reason.append("did not find any beans ");
            reason.append(description);
            reason.append(" ");
            reason.append(StringUtils.collectionToDelimitedString(unmatched, (String)", "));
        }
    }

    private String createOnMissingBeanNoMatchReason(MatchResult matchResult) {
        StringBuilder reason = new StringBuilder();
        this.appendMessageForMatches(reason, matchResult.getMatchedAnnotations(), "annotated with");
        this.appendMessageForMatches(reason, matchResult.getMatchedTypes(), "of type");
        if (!matchResult.getMatchedNames().isEmpty()) {
            if (reason.length() > 0) {
                reason.append(" and ");
            }
            reason.append("found beans named ");
            reason.append(StringUtils.collectionToDelimitedString(matchResult.getMatchedNames(), (String)", "));
        }
        return reason.toString();
    }

    private void appendMessageForMatches(StringBuilder reason, Map<String, Collection<String>> matches, String description) {
        if (!matches.isEmpty()) {
            matches.forEach((key, value) -> {
                if (reason.length() > 0) {
                    reason.append(" and ");
                }
                reason.append("found beans ");
                reason.append(description);
                reason.append(" '");
                reason.append((String)key);
                reason.append("' ");
                reason.append(StringUtils.collectionToDelimitedString((Collection)value, (String)", "));
            });
        }
    }

    private boolean hasSingleAutowireCandidate(ConfigurableListableBeanFactory beanFactory, Set<String> beanNames, boolean considerHierarchy) {
        return beanNames.size() == 1 || this.getPrimaryBeans(beanFactory, beanNames, considerHierarchy).size() == 1;
    }

    private List<String> getPrimaryBeans(ConfigurableListableBeanFactory beanFactory, Set<String> beanNames, boolean considerHierarchy) {
        ArrayList<String> primaryBeans = new ArrayList<String>();
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = this.findBeanDefinition(beanFactory, beanName, considerHierarchy);
            if (beanDefinition == null || !beanDefinition.isPrimary()) continue;
            primaryBeans.add(beanName);
        }
        return primaryBeans;
    }

    private BeanDefinition findBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (beanFactory.containsBeanDefinition(beanName)) {
            return beanFactory.getBeanDefinition(beanName);
        }
        if (considerHierarchy && beanFactory.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
            return this.findBeanDefinition((ConfigurableListableBeanFactory)beanFactory.getParentBeanFactory(), beanName, considerHierarchy);
        }
        return null;
    }

    static final class BeanTypeDeductionException
    extends RuntimeException {
        private BeanTypeDeductionException(String className, String beanMethodName, Throwable cause) {
            super("Failed to deduce bean type for " + className + "." + beanMethodName, cause);
        }
    }

    protected static final class MatchResult {
        private final Map<String, Collection<String>> matchedAnnotations = new HashMap<String, Collection<String>>();
        private final List<String> matchedNames = new ArrayList<String>();
        private final Map<String, Collection<String>> matchedTypes = new HashMap<String, Collection<String>>();
        private final List<String> unmatchedAnnotations = new ArrayList<String>();
        private final List<String> unmatchedNames = new ArrayList<String>();
        private final List<String> unmatchedTypes = new ArrayList<String>();
        private final Set<String> namesOfAllMatches = new HashSet<String>();

        protected MatchResult() {
        }

        private void recordMatchedName(String name) {
            this.matchedNames.add(name);
            this.namesOfAllMatches.add(name);
        }

        private void recordUnmatchedName(String name) {
            this.unmatchedNames.add(name);
        }

        private void recordMatchedAnnotation(String annotation, Collection<String> matchingNames) {
            this.matchedAnnotations.put(annotation, matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedAnnotation(String annotation) {
            this.unmatchedAnnotations.add(annotation);
        }

        private void recordMatchedType(String type, Collection<String> matchingNames) {
            this.matchedTypes.put(type, matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedType(String type) {
            this.unmatchedTypes.add(type);
        }

        public boolean isAllMatched() {
            return this.unmatchedAnnotations.isEmpty() && this.unmatchedNames.isEmpty() && this.unmatchedTypes.isEmpty();
        }

        public boolean isAnyMatched() {
            return !this.matchedAnnotations.isEmpty() || !this.matchedNames.isEmpty() || !this.matchedTypes.isEmpty();
        }

        public Map<String, Collection<String>> getMatchedAnnotations() {
            return this.matchedAnnotations;
        }

        public List<String> getMatchedNames() {
            return this.matchedNames;
        }

        public Map<String, Collection<String>> getMatchedTypes() {
            return this.matchedTypes;
        }

        public List<String> getUnmatchedAnnotations() {
            return this.unmatchedAnnotations;
        }

        public List<String> getUnmatchedNames() {
            return this.unmatchedNames;
        }

        public List<String> getUnmatchedTypes() {
            return this.unmatchedTypes;
        }

        public Set<String> getNamesOfAllMatches() {
            return this.namesOfAllMatches;
        }
    }

    private static class SingleCandidateBeanSearchSpec
    extends BeanSearchSpec {
        SingleCandidateBeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            super(context, metadata, annotationType);
        }

        @Override
        protected void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            super.collect(attributes, key, destination);
            destination.removeAll(Arrays.asList("", Object.class.getName()));
        }

        @Override
        protected void validate(BeanTypeDeductionException ex) {
            Assert.isTrue((this.getTypes().size() == 1 ? 1 : 0) != 0, () -> this.getAnnotationName() + " annotations must specify only one type (got " + this.getTypes() + ")");
        }
    }

    protected static class BeanSearchSpec {
        private final Class<?> annotationType;
        private final List<String> names = new ArrayList<String>();
        private final List<String> types = new ArrayList<String>();
        private final List<String> annotations = new ArrayList<String>();
        private final List<String> ignoredTypes = new ArrayList<String>();
        private final List<String> parameterizedContainers = new ArrayList<String>();
        private final SearchStrategy strategy;

        public BeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            this(context, metadata, annotationType, null);
        }

        public BeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType, Class<?> genericContainer) {
            this.annotationType = annotationType;
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
            this.collect((MultiValueMap<String, Object>)attributes, "name", this.names);
            this.collect((MultiValueMap<String, Object>)attributes, "value", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "type", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "annotation", this.annotations);
            this.collect((MultiValueMap<String, Object>)attributes, "ignored", this.ignoredTypes);
            this.collect((MultiValueMap<String, Object>)attributes, "ignoredType", this.ignoredTypes);
            this.collect((MultiValueMap<String, Object>)attributes, "parameterizedContainer", this.parameterizedContainers);
            this.strategy = (SearchStrategy)((Object)attributes.getFirst((Object)"search"));
            BeanTypeDeductionException deductionException = null;
            try {
                if (this.types.isEmpty() && this.names.isEmpty()) {
                    this.addDeducedBeanType(context, metadata, this.types);
                }
            }
            catch (BeanTypeDeductionException ex) {
                deductionException = ex;
            }
            this.validate(deductionException);
        }

        protected void validate(BeanTypeDeductionException ex) {
            if (!this.hasAtLeastOne(this.types, this.names, this.annotations)) {
                String message = this.getAnnotationName() + " did not specify a bean using type, name or annotation";
                if (ex == null) {
                    throw new IllegalStateException(message);
                }
                throw new IllegalStateException(message + " and the attempt to deduce the bean's type failed", ex);
            }
        }

        private boolean hasAtLeastOne(List<?> ... lists) {
            return Arrays.stream(lists).anyMatch(list -> !list.isEmpty());
        }

        protected final String getAnnotationName() {
            return "@" + ClassUtils.getShortName(this.annotationType);
        }

        protected void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            List values = (List)attributes.get((Object)key);
            if (values != null) {
                for (Object value : values) {
                    if (value instanceof String[]) {
                        Collections.addAll(destination, (String[])value);
                        continue;
                    }
                    destination.add((String)value);
                }
            }
        }

        private void addDeducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata, List<String> beanTypes) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                this.addDeducedBeanTypeForBeanMethod(context, (MethodMetadata)metadata, beanTypes);
            }
        }

        private void addDeducedBeanTypeForBeanMethod(ConditionContext context, MethodMetadata metadata, List<String> beanTypes) {
            try {
                Class<?> returnType = this.getReturnType(context, metadata);
                beanTypes.add(returnType.getName());
            }
            catch (Throwable ex) {
                throw new BeanTypeDeductionException(metadata.getDeclaringClassName(), metadata.getMethodName(), ex);
            }
        }

        private Class<?> getReturnType(ConditionContext context, MethodMetadata metadata) throws ClassNotFoundException, LinkageError {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> returnType = ClassUtils.forName((String)metadata.getReturnTypeName(), (ClassLoader)classLoader);
            if (this.isParameterizedContainer(returnType, classLoader)) {
                returnType = this.getReturnTypeGeneric(metadata, classLoader);
            }
            return returnType;
        }

        private Class<?> getReturnTypeGeneric(MethodMetadata metadata, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
            Class declaringClass = ClassUtils.forName((String)metadata.getDeclaringClassName(), (ClassLoader)classLoader);
            Method beanMethod = this.findBeanMethod(declaringClass, metadata.getMethodName());
            return ResolvableType.forMethodReturnType((Method)beanMethod).resolveGeneric(new int[0]);
        }

        private Method findBeanMethod(Class<?> declaringClass, String methodName) {
            Method method = ReflectionUtils.findMethod(declaringClass, (String)methodName);
            if (this.isBeanMethod(method)) {
                return method;
            }
            return Arrays.stream(ReflectionUtils.getAllDeclaredMethods(declaringClass)).filter(candidate -> candidate.getName().equals(methodName)).filter(this::isBeanMethod).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find bean method " + methodName));
        }

        private boolean isBeanMethod(Method method) {
            return method != null && MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.EXHAUSTIVE).isPresent(Bean.class);
        }

        public BeanTypeRegistry.TypeExtractor getTypeExtractor(ClassLoader classLoader) {
            if (this.parameterizedContainers.isEmpty()) {
                return ResolvableType::resolve;
            }
            return type -> {
                Class resolved = type.resolve();
                if (this.isParameterizedContainer(resolved, classLoader)) {
                    return type.getGeneric(new int[0]).resolve();
                }
                return resolved;
            };
        }

        private boolean isParameterizedContainer(Class<?> type, ClassLoader classLoader) {
            for (String candidate : this.parameterizedContainers) {
                try {
                    if (!ClassUtils.forName((String)candidate, (ClassLoader)classLoader).isAssignableFrom(type)) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }

        public SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        public List<String> getNames() {
            return this.names;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public List<String> getIgnoredTypes() {
            return this.ignoredTypes;
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            string.append("(");
            if (!this.names.isEmpty()) {
                string.append("names: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.names));
                if (!this.types.isEmpty()) {
                    string.append("; ");
                }
            }
            if (!this.types.isEmpty()) {
                string.append("types: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.types));
            }
            string.append("; SearchStrategy: ");
            string.append(this.strategy.toString().toLowerCase(Locale.ENGLISH));
            string.append(")");
            return string.toString();
        }
    }
}

