/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Arrays;
import javax.persistence.EntityManager;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.ClassUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class, EntityManager.class})
@Conditional(value={HibernateEntityManagerCondition.class})
@EnableConfigurationProperties(value={JpaProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@Import(value={HibernateJpaConfiguration.class})
public class HibernateJpaAutoConfiguration {

    @Order(value=-2147483628)
    static class HibernateEntityManagerCondition
    extends SpringBootCondition {
        private static final String[] CLASS_NAMES = new String[]{"org.hibernate.ejb.HibernateEntityManager", "org.hibernate.jpa.HibernateEntityManager"};

        HibernateEntityManagerCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition("HibernateEntityManager", new Object[0]);
            for (String className : CLASS_NAMES) {
                if (!ClassUtils.isPresent((String)className, (ClassLoader)context.getClassLoader())) continue;
                return ConditionOutcome.match(message.found("class").items(ConditionMessage.Style.QUOTE, className));
            }
            return ConditionOutcome.noMatch(message.didNotFind("class", "classes").items(ConditionMessage.Style.QUOTE, Arrays.asList(CLASS_NAMES)));
        }
    }
}

