/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.rsocket;

import io.rsocket.RSocketFactory;
import io.rsocket.SocketAcceptor;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.WebsocketRouteTransport;
import org.springframework.boot.web.embedded.netty.NettyRouteProvider;
import reactor.netty.http.server.HttpServerRoutes;

class RSocketWebSocketNettyRouteProvider
implements NettyRouteProvider {
    private final String mappingPath;
    private final SocketAcceptor socketAcceptor;

    RSocketWebSocketNettyRouteProvider(String mappingPath, SocketAcceptor socketAcceptor) {
        this.mappingPath = mappingPath;
        this.socketAcceptor = socketAcceptor;
    }

    public HttpServerRoutes apply(HttpServerRoutes httpServerRoutes) {
        ServerTransport.ConnectionAcceptor acceptor = RSocketFactory.receive().acceptor(this.socketAcceptor).toConnectionAcceptor();
        return httpServerRoutes.ws(this.mappingPath, WebsocketRouteTransport.newHandler((ServerTransport.ConnectionAcceptor)acceptor));
    }
}

