/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import io.netty.handler.ssl.SslContextBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ClientHttpConnectorFactory;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ReactorNettyHttpClientMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.client.reactive.ReactorResourceFactory;
import org.springframework.util.function.ThrowingConsumer;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;

class ReactorClientHttpConnectorFactory
implements ClientHttpConnectorFactory<ReactorClientHttpConnector> {
    private final ReactorResourceFactory reactorResourceFactory;
    private final Supplier<Stream<ReactorNettyHttpClientMapper>> mappers;

    ReactorClientHttpConnectorFactory(ReactorResourceFactory reactorResourceFactory) {
        this(reactorResourceFactory, Stream::empty);
    }

    ReactorClientHttpConnectorFactory(ReactorResourceFactory reactorResourceFactory, Supplier<Stream<ReactorNettyHttpClientMapper>> mappers) {
        this.reactorResourceFactory = reactorResourceFactory;
        this.mappers = mappers;
    }

    @Override
    public ReactorClientHttpConnector createClientHttpConnector(SslBundle sslBundle) {
        List mappers = this.mappers.get().collect(Collectors.toCollection(ArrayList::new));
        if (sslBundle != null) {
            mappers.add(new SslConfigurer(sslBundle));
        }
        return new ReactorClientHttpConnector(this.reactorResourceFactory, ReactorNettyHttpClientMapper.of(mappers)::configure);
    }

    private static class SslConfigurer
    implements ReactorNettyHttpClientMapper {
        private final SslBundle sslBundle;

        SslConfigurer(SslBundle sslBundle) {
            this.sslBundle = sslBundle;
        }

        @Override
        public HttpClient configure(HttpClient httpClient) {
            return httpClient.secure((Consumer)ThrowingConsumer.of(this::customizeSsl).throwing(IllegalStateException::new));
        }

        private void customizeSsl(SslProvider.SslContextSpec spec) throws SSLException {
            SslOptions options = this.sslBundle.getOptions();
            SslManagerBundle managers = this.sslBundle.getManagers();
            SslContextBuilder builder = SslContextBuilder.forClient().keyManager(managers.getKeyManagerFactory()).trustManager(managers.getTrustManagerFactory()).ciphers((Iterable)SslOptions.asSet((String[])options.getCiphers())).protocols(options.getEnabledProtocols());
            spec.sslContext(builder.build());
        }
    }
}

