/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.batch.autoconfigure;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.batch.autoconfigure.JobExecutionEvent;
import org.springframework.context.ApplicationListener;

public class JobExecutionExitCodeGenerator
implements ApplicationListener<JobExecutionEvent>,
ExitCodeGenerator {
    private final List<JobExecution> executions = new CopyOnWriteArrayList<JobExecution>();

    public void onApplicationEvent(JobExecutionEvent event) {
        this.executions.add(event.getJobExecution());
    }

    public int getExitCode() {
        for (JobExecution execution : this.executions) {
            if (execution.getStatus().ordinal() <= 0) continue;
            return execution.getStatus().ordinal();
        }
        return 0;
    }
}

