/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import com.sun.jna.Platform;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.springframework.boot.buildpack.platform.docker.configuration.ResolvedDockerHost;
import org.springframework.boot.buildpack.platform.docker.transport.HttpClientTransport;
import org.springframework.boot.buildpack.platform.socket.DomainSocket;
import org.springframework.boot.buildpack.platform.socket.NamedPipeSocket;

final class LocalHttpClientTransport
extends HttpClientTransport {
    private static final HttpHost LOCAL_DOCKER_HOST;

    private LocalHttpClientTransport(HttpClient client) {
        super(client, LOCAL_DOCKER_HOST);
    }

    static LocalHttpClientTransport create(ResolvedDockerHost dockerHost) {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)new LocalConnectionManager(dockerHost.getAddress()));
        builder.setSchemePortResolver((SchemePortResolver)new LocalSchemePortResolver());
        return new LocalHttpClientTransport((HttpClient)builder.build());
    }

    static {
        try {
            LOCAL_DOCKER_HOST = HttpHost.create((String)"docker://localhost");
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Error creating local Docker host address", ex);
        }
    }

    private static class LocalConnectionManager
    extends BasicHttpClientConnectionManager {
        LocalConnectionManager(String host) {
            super(LocalConnectionManager.getRegistry(host), null, null, (DnsResolver)new LocalDnsResolver());
        }

        private static Registry<ConnectionSocketFactory> getRegistry(String host) {
            RegistryBuilder builder = RegistryBuilder.create();
            builder.register("docker", (Object)new LocalConnectionSocketFactory(host));
            return builder.build();
        }
    }

    private static final class LocalSchemePortResolver
    implements SchemePortResolver {
        private static final int DEFAULT_DOCKER_PORT = 2376;

        private LocalSchemePortResolver() {
        }

        public int resolve(HttpHost host) {
            Args.notNull((Object)host, (String)"HTTP host");
            String name = host.getSchemeName();
            if ("docker".equals(name)) {
                return 2376;
            }
            return -1;
        }
    }

    private static class LocalConnectionSocketFactory
    implements ConnectionSocketFactory {
        private final String host;

        LocalConnectionSocketFactory(String host) {
            this.host = host;
        }

        public Socket createSocket(HttpContext context) throws IOException {
            if (Platform.isWindows()) {
                return NamedPipeSocket.get(this.host);
            }
            return DomainSocket.get(this.host);
        }

        public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            return socket;
        }
    }

    private static final class LocalDnsResolver
    implements DnsResolver {
        private static final InetAddress LOOPBACK = InetAddress.getLoopbackAddress();

        private LocalDnsResolver() {
        }

        public InetAddress[] resolve(String host) throws UnknownHostException {
            return new InetAddress[]{LOOPBACK};
        }

        public String resolveCanonicalHostname(String host) throws UnknownHostException {
            return LOOPBACK.getCanonicalHostName();
        }
    }
}

