/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import com.sun.jna.Platform;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.build.ApiVersion;
import org.springframework.boot.buildpack.platform.build.ApiVersions;
import org.springframework.boot.buildpack.platform.build.BuildLog;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.BuilderException;
import org.springframework.boot.buildpack.platform.build.BuilderMetadata;
import org.springframework.boot.buildpack.platform.build.Cache;
import org.springframework.boot.buildpack.platform.build.EphemeralBuilder;
import org.springframework.boot.buildpack.platform.build.LifecycleVersion;
import org.springframework.boot.buildpack.platform.build.Phase;
import org.springframework.boot.buildpack.platform.docker.DockerApi;
import org.springframework.boot.buildpack.platform.docker.LogUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.configuration.ResolvedDockerHost;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.ContainerConfig;
import org.springframework.boot.buildpack.platform.docker.type.ContainerContent;
import org.springframework.boot.buildpack.platform.docker.type.ContainerReference;
import org.springframework.boot.buildpack.platform.docker.type.ContainerStatus;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;
import org.springframework.util.FileSystemUtils;

class Lifecycle
implements Closeable {
    private static final LifecycleVersion LOGGING_MINIMUM_VERSION = LifecycleVersion.parse("0.0.5");
    private static final String PLATFORM_API_VERSION_KEY = "CNB_PLATFORM_API";
    private static final String SOURCE_DATE_EPOCH_KEY = "SOURCE_DATE_EPOCH";
    private static final String DOMAIN_SOCKET_PATH = "/var/run/docker.sock";
    private static final List<String> DEFAULT_SECURITY_OPTIONS = List.of("label=disable");
    private final BuildLog log;
    private final DockerApi docker;
    private final ResolvedDockerHost dockerHost;
    private final BuildRequest request;
    private final EphemeralBuilder builder;
    private final LifecycleVersion lifecycleVersion;
    private final ApiVersion platformVersion;
    private final Cache layers;
    private final Cache application;
    private final Cache buildCache;
    private final Cache launchCache;
    private final String applicationDirectory;
    private final List<String> securityOptions;
    private boolean executed;
    private boolean applicationVolumePopulated;

    Lifecycle(BuildLog log, DockerApi docker, ResolvedDockerHost dockerHost, BuildRequest request, EphemeralBuilder builder) {
        this.log = log;
        this.docker = docker;
        this.dockerHost = dockerHost;
        this.request = request;
        this.builder = builder;
        this.lifecycleVersion = LifecycleVersion.parse(builder.getBuilderMetadata().getLifecycle().getVersion());
        this.platformVersion = this.getPlatformVersion(builder.getBuilderMetadata().getLifecycle());
        this.layers = this.getLayersBindingSource(request);
        this.application = this.getApplicationBindingSource(request);
        this.buildCache = this.getBuildCache(request);
        this.launchCache = this.getLaunchCache(request);
        this.applicationDirectory = this.getApplicationDirectory(request);
        this.securityOptions = this.getSecurityOptions(request);
    }

    String getApplicationDirectory() {
        return this.applicationDirectory;
    }

    private Cache getBuildCache(BuildRequest request) {
        if (request.getBuildCache() != null) {
            return request.getBuildCache();
        }
        return this.createVolumeCache(request, "build");
    }

    private Cache getLaunchCache(BuildRequest request) {
        if (request.getLaunchCache() != null) {
            return request.getLaunchCache();
        }
        return this.createVolumeCache(request, "launch");
    }

    private String getApplicationDirectory(BuildRequest request) {
        return request.getApplicationDirectory() != null ? request.getApplicationDirectory() : "/workspace";
    }

    private List<String> getSecurityOptions(BuildRequest request) {
        if (request.getSecurityOptions() != null) {
            return request.getSecurityOptions();
        }
        return Platform.isWindows() ? Collections.emptyList() : DEFAULT_SECURITY_OPTIONS;
    }

    private ApiVersion getPlatformVersion(BuilderMetadata.Lifecycle lifecycle) {
        if (lifecycle.getApis().getPlatform() != null) {
            String[] supportedVersions = lifecycle.getApis().getPlatform();
            return ApiVersions.SUPPORTED_PLATFORMS.findLatestSupported(supportedVersions);
        }
        String version = lifecycle.getApi().getPlatform();
        return ApiVersions.SUPPORTED_PLATFORMS.findLatestSupported(version);
    }

    void execute() throws IOException {
        Assert.state((!this.executed ? 1 : 0) != 0, (String)"Lifecycle has already been executed");
        this.executed = true;
        this.log.executingLifecycle(this.request, this.lifecycleVersion, this.buildCache);
        if (this.request.isCleanCache()) {
            this.deleteCache(this.buildCache);
        }
        this.run(this.createPhase());
        this.log.executedLifecycle(this.request);
    }

    private Phase createPhase() {
        Phase phase = new Phase("creator", this.isVerboseLogging());
        phase.withDaemonAccess();
        this.configureDaemonAccess(phase);
        phase.withLogLevelArg();
        phase.withArgs("-app", this.applicationDirectory);
        phase.withArgs("-platform", "/platform");
        phase.withArgs("-run-image", this.request.getRunImage());
        phase.withArgs("-layers", "/layers");
        phase.withArgs("-cache-dir", "/cache");
        phase.withArgs("-launch-cache", "/launch-cache");
        phase.withArgs("-daemon");
        if (this.request.isCleanCache()) {
            phase.withArgs("-skip-restore");
        }
        if (this.requiresProcessTypeDefault()) {
            phase.withArgs("-process-type=web");
        }
        phase.withArgs(this.request.getName());
        phase.withBinding(Binding.from(this.getCacheBindingSource(this.layers), "/layers"));
        phase.withBinding(Binding.from(this.getCacheBindingSource(this.application), this.applicationDirectory));
        phase.withBinding(Binding.from(this.getCacheBindingSource(this.buildCache), "/cache"));
        phase.withBinding(Binding.from(this.getCacheBindingSource(this.launchCache), "/launch-cache"));
        if (this.request.getBindings() != null) {
            this.request.getBindings().forEach(phase::withBinding);
        }
        phase.withEnv(PLATFORM_API_VERSION_KEY, this.platformVersion.toString());
        if (this.request.getNetwork() != null) {
            phase.withNetworkMode(this.request.getNetwork());
        }
        if (this.request.getCreatedDate() != null) {
            phase.withEnv(SOURCE_DATE_EPOCH_KEY, Long.toString(this.request.getCreatedDate().getEpochSecond()));
        }
        return phase;
    }

    private Cache getLayersBindingSource(BuildRequest request) {
        if (request.getBuildWorkspace() != null) {
            return this.getBuildWorkspaceBindingSource(request.getBuildWorkspace(), "layers");
        }
        return this.createVolumeCache("pack-layers-");
    }

    private Cache getApplicationBindingSource(BuildRequest request) {
        if (request.getBuildWorkspace() != null) {
            return this.getBuildWorkspaceBindingSource(request.getBuildWorkspace(), "app");
        }
        return this.createVolumeCache("pack-app-");
    }

    private Cache getBuildWorkspaceBindingSource(Cache buildWorkspace, String suffix) {
        return buildWorkspace.getVolume() != null ? Cache.volume(buildWorkspace.getVolume().getName() + "-" + suffix) : Cache.bind(buildWorkspace.getBind().getSource() + "-" + suffix);
    }

    private String getCacheBindingSource(Cache cache) {
        return cache.getVolume() != null ? cache.getVolume().getName() : cache.getBind().getSource();
    }

    private Cache createVolumeCache(String prefix) {
        return Cache.volume(this.createRandomVolumeName(prefix));
    }

    private Cache createVolumeCache(BuildRequest request, String suffix) {
        return Cache.volume(VolumeName.basedOn(request.getName(), ImageReference::toLegacyString, "pack-cache-", "." + suffix, 6));
    }

    protected VolumeName createRandomVolumeName(String prefix) {
        return VolumeName.random(prefix);
    }

    private void configureDaemonAccess(Phase phase) {
        if (this.dockerHost != null) {
            if (this.dockerHost.isRemote()) {
                phase.withEnv("DOCKER_HOST", this.dockerHost.getAddress());
                if (this.dockerHost.isSecure()) {
                    phase.withEnv("DOCKER_TLS_VERIFY", "1");
                    phase.withEnv("DOCKER_CERT_PATH", this.dockerHost.getCertificatePath());
                }
            } else {
                phase.withBinding(Binding.from(this.dockerHost.getAddress(), DOMAIN_SOCKET_PATH));
            }
        } else {
            phase.withBinding(Binding.from(DOMAIN_SOCKET_PATH, DOMAIN_SOCKET_PATH));
        }
        if (this.securityOptions != null) {
            this.securityOptions.forEach(phase::withSecurityOption);
        }
    }

    private boolean isVerboseLogging() {
        return this.request.isVerboseLogging() && this.lifecycleVersion.isEqualOrGreaterThan(LOGGING_MINIMUM_VERSION);
    }

    private boolean requiresProcessTypeDefault() {
        return this.platformVersion.supportsAny(ApiVersion.of(0, 4), ApiVersion.of(0, 5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Phase phase) throws IOException {
        Consumer<LogUpdateEvent> logConsumer = this.log.runningPhase(this.request, phase.getName());
        ContainerConfig containerConfig = ContainerConfig.of(this.builder.getName(), phase::apply);
        ContainerReference reference = this.createContainer(containerConfig);
        try {
            this.docker.container().start(reference);
            this.docker.container().logs(reference, logConsumer::accept);
            ContainerStatus status = this.docker.container().wait(reference);
            if (status.getStatusCode() != 0) {
                throw new BuilderException(phase.getName(), status.getStatusCode());
            }
        }
        finally {
            this.docker.container().remove(reference, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerReference createContainer(ContainerConfig config) throws IOException {
        if (this.applicationVolumePopulated) {
            return this.docker.container().create(config, new ContainerContent[0]);
        }
        try {
            if (this.application.getBind() != null) {
                Files.createDirectories(Path.of(this.application.getBind().getSource(), new String[0]), new FileAttribute[0]);
            }
            TarArchive applicationContent = this.request.getApplicationContent(this.builder.getBuildOwner());
            ContainerReference containerReference = this.docker.container().create(config, ContainerContent.of(applicationContent, this.applicationDirectory));
            return containerReference;
        }
        finally {
            this.applicationVolumePopulated = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.deleteCache(this.layers);
        this.deleteCache(this.application);
    }

    private void deleteCache(Cache cache) throws IOException {
        if (cache.getVolume() != null) {
            this.deleteVolume(cache.getVolume().getVolumeName());
        }
        if (cache.getBind() != null) {
            this.deleteBind(cache.getBind());
        }
    }

    private void deleteVolume(VolumeName name) throws IOException {
        this.docker.volume().delete(name, true);
    }

    private void deleteBind(Cache.Bind bind) {
        try {
            FileSystemUtils.deleteRecursively((Path)Path.of(bind.getSource(), new String[0]));
        }
        catch (Exception ex) {
            this.log.failedCleaningWorkDir(bind, ex);
        }
    }

    private static final class Directory {
        static final String LAYERS = "/layers";
        static final String APPLICATION = "/workspace";
        static final String PLATFORM = "/platform";
        static final String CACHE = "/cache";
        static final String LAUNCH_CACHE = "/launch-cache";

        private Directory() {
        }
    }
}

