/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.configuration;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.boot.buildpack.platform.docker.configuration.Credential;
import org.springframework.boot.buildpack.platform.docker.configuration.CredentialHelper;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfigurationMetadata;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryAuthentication;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.system.Environment;
import org.springframework.util.StringUtils;

class DockerRegistryConfigAuthentication
implements DockerRegistryAuthentication {
    private static final String DEFAULT_DOMAIN = "docker.io";
    private static final String INDEX_URL = "https://index.docker.io/v1/";
    static Map<String, Credential> credentialFromHelperCache = new ConcurrentHashMap<String, Credential>();
    private final DockerRegistryAuthentication fallback;
    private final BiConsumer<String, Exception> credentialHelperExceptionHandler;
    private final Function<String, CredentialHelper> credentialHelperFactory;
    private final DockerConfigurationMetadata.DockerConfig dockerConfig;

    DockerRegistryConfigAuthentication(DockerRegistryAuthentication fallback, BiConsumer<String, Exception> credentialHelperExceptionHandler) {
        this(fallback, credentialHelperExceptionHandler, Environment.SYSTEM, helper -> new CredentialHelper("docker-credential-" + helper));
    }

    DockerRegistryConfigAuthentication(DockerRegistryAuthentication fallback, BiConsumer<String, Exception> credentialHelperExceptionHandler, Environment environment, Function<String, CredentialHelper> credentialHelperFactory) {
        this.fallback = fallback;
        this.credentialHelperExceptionHandler = credentialHelperExceptionHandler;
        this.dockerConfig = DockerConfigurationMetadata.from(environment).getConfiguration();
        this.credentialHelperFactory = credentialHelperFactory;
    }

    @Override
    public String getAuthHeader() {
        return this.getAuthHeader(null);
    }

    @Override
    public String getAuthHeader(ImageReference imageReference) {
        String serverUrl = this.getServerUrl(imageReference);
        DockerRegistryAuthentication authentication = this.getAuthentication(serverUrl);
        return authentication != null ? authentication.getAuthHeader(imageReference) : null;
    }

    private String getServerUrl(ImageReference imageReference) {
        String domain = imageReference != null ? imageReference.getDomain() : null;
        return !DEFAULT_DOMAIN.equals(domain) ? domain : INDEX_URL;
    }

    private DockerRegistryAuthentication getAuthentication(String serverUrl) {
        DockerConfigurationMetadata.Auth authConfig;
        Credential credentialsFromHelper = this.getCredentialsFromHelper(serverUrl);
        Map.Entry<String, DockerConfigurationMetadata.Auth> authConfigEntry = this.getAuthConfigEntry(serverUrl);
        DockerConfigurationMetadata.Auth auth = authConfig = authConfigEntry != null ? authConfigEntry.getValue() : null;
        if (credentialsFromHelper != null) {
            return this.getAuthentication(credentialsFromHelper, authConfig, serverUrl);
        }
        if (authConfig != null) {
            return DockerRegistryAuthentication.user(authConfig.getUsername(), authConfig.getPassword(), authConfigEntry.getKey(), authConfig.getEmail());
        }
        return this.fallback;
    }

    private DockerRegistryAuthentication getAuthentication(Credential credentialsFromHelper, DockerConfigurationMetadata.Auth authConfig, String serverUrl) {
        if (credentialsFromHelper.isIdentityToken()) {
            return DockerRegistryAuthentication.token(credentialsFromHelper.getSecret());
        }
        String username = credentialsFromHelper.getUsername();
        String password = credentialsFromHelper.getSecret();
        String serverAddress = StringUtils.hasLength((String)credentialsFromHelper.getServerUrl()) ? credentialsFromHelper.getServerUrl() : serverUrl;
        String email = authConfig != null ? authConfig.getEmail() : null;
        return DockerRegistryAuthentication.user(username, password, serverAddress, email);
    }

    private Credential getCredentialsFromHelper(String serverUrl) {
        return StringUtils.hasLength((String)serverUrl) ? credentialFromHelperCache.computeIfAbsent(serverUrl, this::computeCredentialsFromHelper) : null;
    }

    private Credential computeCredentialsFromHelper(String serverUrl) {
        CredentialHelper credentialHelper = this.getCredentialHelper(serverUrl);
        if (credentialHelper != null) {
            try {
                return credentialHelper.get(serverUrl);
            }
            catch (Exception ex) {
                String message = "Error retrieving credentials for '%s' due to: %s".formatted(serverUrl, ex.getMessage());
                this.credentialHelperExceptionHandler.accept(message, ex);
            }
        }
        return null;
    }

    private CredentialHelper getCredentialHelper(String serverUrl) {
        String name = this.dockerConfig.getCredHelpers().getOrDefault(serverUrl, this.dockerConfig.getCredsStore());
        return StringUtils.hasLength((String)name) ? this.credentialHelperFactory.apply(name) : null;
    }

    private Map.Entry<String, DockerConfigurationMetadata.Auth> getAuthConfigEntry(String serverUrl) {
        for (Map.Entry<String, DockerConfigurationMetadata.Auth> candidate : this.dockerConfig.getAuths().entrySet()) {
            if (!candidate.getKey().equals(serverUrl) && !candidate.getKey().endsWith("://" + serverUrl)) continue;
            return candidate;
        }
        return null;
    }
}

