/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public final class ApiVersion
implements Comparable<ApiVersion> {
    private static final Pattern PATTERN = Pattern.compile("^v?(\\d+)\\.(\\d*)$");
    private static final Comparator<ApiVersion> COMPARATOR = Comparator.comparing(ApiVersion::getMajor).thenComparing(ApiVersion::getMinor);
    private final int major;
    private final int minor;

    private ApiVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    public boolean supports(ApiVersion other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.major == 0 || this.major != other.major) {
            return false;
        }
        return this.minor >= other.minor;
    }

    public boolean supportsAny(ApiVersion ... others) {
        for (ApiVersion other : others) {
            if (!this.supports(other)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiVersion other = (ApiVersion)obj;
        return this.major == other.major && this.minor == other.minor;
    }

    public int hashCode() {
        return this.major * 31 + this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public static ApiVersion parse(String value) {
        Assert.hasText((String)value, (String)"'value' must not be empty");
        Matcher matcher = PATTERN.matcher(value);
        Assert.isTrue((boolean)matcher.matches(), () -> "'value' [%s] must contain a well formed version number".formatted(value));
        try {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            return new ApiVersion(major, minor);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'value' must contain a well formed version number [" + value + "]", ex);
        }
    }

    public static ApiVersion of(int major, int minor) {
        return new ApiVersion(major, minor);
    }

    @Override
    public int compareTo(ApiVersion other) {
        return COMPARATOR.compare(this, other);
    }
}

