/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.type.BlobReference;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.util.Assert;

public class Manifest
extends MappedObject {
    private final Integer schemaVersion = this.extractSchemaVersion();
    private final @Nullable String mediaType = this.valueAt("/mediaType", String.class);
    private final List<BlobReference> layers = this.childrenAt("/layers", BlobReference::new);

    protected Manifest(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    private Integer extractSchemaVersion() {
        Integer result = this.valueAt("/schemaVersion", Integer.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"'result' must not be null");
        return result;
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public @Nullable String getMediaType() {
        return this.mediaType;
    }

    public List<BlobReference> getLayers() {
        return this.layers;
    }

    public static Manifest of(InputStream content) throws IOException {
        return Manifest.of(content, Manifest::new);
    }
}

