/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.build.BuildLog;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.Cache;
import org.springframework.boot.buildpack.platform.build.ImageType;
import org.springframework.boot.buildpack.platform.build.LifecycleVersion;
import org.springframework.boot.buildpack.platform.docker.ImagePlatform;
import org.springframework.boot.buildpack.platform.docker.LogUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;

public abstract class AbstractBuildLog
implements BuildLog {
    @Override
    public void start(BuildRequest request) {
        this.log("Building image '" + String.valueOf(request.getName()) + "'");
        this.log();
    }

    @Override
    public Consumer<TotalProgressEvent> pullingImage(ImageReference imageReference, @Nullable ImagePlatform platform, ImageType imageType) {
        return platform != null ? this.getProgressConsumer(" > Pulling %s '%s' for platform '%s'".formatted(imageType.getDescription(), imageReference, platform)) : this.getProgressConsumer(" > Pulling %s '%s'".formatted(imageType.getDescription(), imageReference));
    }

    @Override
    public void pulledImage(Image image, ImageType imageType) {
        this.log(String.format(" > Pulled %s '%s'", imageType.getDescription(), this.getDigest(image)));
    }

    @Override
    public Consumer<TotalProgressEvent> pushingImage(ImageReference imageReference) {
        return this.getProgressConsumer(String.format(" > Pushing image '%s'", imageReference));
    }

    @Override
    public void pushedImage(ImageReference imageReference) {
        this.log(String.format(" > Pushed image '%s'", imageReference));
    }

    @Override
    public void executingLifecycle(BuildRequest request, LifecycleVersion version, VolumeName buildCacheVolume) {
        this.log(" > Executing lifecycle version " + String.valueOf(version));
        this.log(" > Using build cache volume '" + String.valueOf(buildCacheVolume) + "'");
    }

    @Override
    public void executingLifecycle(BuildRequest request, LifecycleVersion version, Cache buildCache) {
        this.log(" > Executing lifecycle version " + String.valueOf(version));
        this.log(" > Using build cache " + String.valueOf(buildCache));
    }

    @Override
    public Consumer<LogUpdateEvent> runningPhase(BuildRequest request, String name) {
        this.log();
        this.log(" > Running " + name);
        String prefix = String.format("    %-14s", "[" + name + "] ");
        return event -> this.log(prefix + String.valueOf(event));
    }

    @Override
    public void skippingPhase(String name, String reason) {
        this.log();
        this.log(" > Skipping " + name + " " + reason);
        this.log();
    }

    @Override
    public void executedLifecycle(BuildRequest request) {
        this.log();
        this.log("Successfully built image '" + String.valueOf(request.getName()) + "'");
        this.log();
    }

    @Override
    public void taggedImage(ImageReference tag) {
        this.log("Successfully created image tag '" + String.valueOf(tag) + "'");
        this.log();
    }

    @Override
    public void failedCleaningWorkDir(Cache cache, @Nullable Exception exception) {
        StringBuilder message = new StringBuilder("Warning: Working location " + String.valueOf(cache) + " could not be cleaned");
        if (exception != null) {
            message.append(": ").append(exception.getMessage());
        }
        this.log();
        this.log(message.toString());
        this.log();
    }

    @Override
    public void sensitiveTargetBindingDetected(Binding binding) {
        this.log("Warning: Binding '%s' uses a container path which is used by buildpacks while building. Binding to it can cause problems!".formatted(binding));
        this.log();
    }

    private String getDigest(Image image) {
        List<String> digests = image.getDigests();
        return digests.isEmpty() ? "" : digests.get(0);
    }

    protected void log() {
        this.log("");
    }

    protected abstract void log(String var1);

    protected abstract Consumer<TotalProgressEvent> getProgressConsumer(String var1);
}

