/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageConfig;
import org.springframework.util.Assert;

class StackId {
    private static final String LABEL_NAME = "io.buildpacks.stack.id";
    private final @Nullable String value;

    StackId(@Nullable String value) {
        this.value = value;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.value, ((StackId)obj).value);
    }

    boolean hasId() {
        return this.value != null;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? this.value : "<null>";
    }

    static StackId fromImage(Image image) {
        Assert.notNull((Object)image, (String)"'image' must not be null");
        return StackId.fromImageConfig(image.getConfig());
    }

    private static StackId fromImageConfig(ImageConfig imageConfig) {
        String value = imageConfig.getLabels().get(LABEL_NAME);
        return new StackId(value);
    }

    static StackId of(String value) {
        Assert.hasText((String)value, (String)"'value' must not be empty");
        return new StackId(value);
    }
}

