/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

class TypeExcludeFilter {
    private final Set<String> excludes = new HashSet<String>();

    TypeExcludeFilter() {
        this.add("com.zaxxer.hikari.IConnectionCustomizer");
        this.add("groovy.lang.MetaClass");
        this.add("groovy.text.markup.MarkupTemplateEngine");
        this.add("java.io.Writer");
        this.add("java.io.PrintWriter");
        this.add("java.lang.ClassLoader");
        this.add("java.util.concurrent.ThreadFactory");
        this.add("javax.jms.XAConnectionFactory");
        this.add("javax.sql.DataSource");
        this.add("javax.sql.XADataSource");
        this.add("org.apache.tomcat.jdbc.pool.PoolConfiguration");
        this.add("org.apache.tomcat.jdbc.pool.Validator");
        this.add("org.flywaydb.core.api.callback.FlywayCallback");
        this.add("org.flywaydb.core.api.resolver.MigrationResolver");
    }

    private void add(String className) {
        this.excludes.add(className);
    }

    public boolean isExcluded(TypeMirror type) {
        if (type == null) {
            return false;
        }
        String typeName = type.toString();
        if (typeName.endsWith("[]")) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        return this.excludes.contains(typeName);
    }
}

