/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.autoconfigure.metrics.DataMetricsProperties;
import org.springframework.boot.data.autoconfigure.metrics.MetricsRepositoryMethodInvocationListenerBeanPostProcessor;
import org.springframework.boot.data.autoconfigure.metrics.PropertiesAutoTimer;
import org.springframework.boot.data.metrics.DefaultRepositoryTagsProvider;
import org.springframework.boot.data.metrics.MetricsRepositoryMethodInvocationListener;
import org.springframework.boot.data.metrics.RepositoryTagsProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.data.repository.Repository;
import org.springframework.util.function.SingletonSupplier;

@AutoConfiguration(afterName={"org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration", "org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration", "org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration"})
@ConditionalOnClass(value={Repository.class})
@ConditionalOnBean(value={MeterRegistry.class})
@EnableConfigurationProperties(value={DataMetricsProperties.class})
public final class DataRepositoryMetricsAutoConfiguration {
    private final DataMetricsProperties properties;

    DataRepositoryMetricsAutoConfiguration(DataMetricsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RepositoryTagsProvider.class})
    DefaultRepositoryTagsProvider repositoryTagsProvider() {
        return new DefaultRepositoryTagsProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    MetricsRepositoryMethodInvocationListener metricsRepositoryMethodInvocationListener(ObjectProvider<MeterRegistry> registry, RepositoryTagsProvider tagsProvider) {
        DataMetricsProperties.Repository properties = this.properties.getRepository();
        return new MetricsRepositoryMethodInvocationListener(() -> registry.getObject(), tagsProvider, properties.getMetricName(), new PropertiesAutoTimer(properties.getAutotime()));
    }

    @Bean
    static MetricsRepositoryMethodInvocationListenerBeanPostProcessor metricsRepositoryMethodInvocationListenerBeanPostProcessor(ObjectProvider<MetricsRepositoryMethodInvocationListener> metricsRepositoryMethodInvocationListener) {
        return new MetricsRepositoryMethodInvocationListenerBeanPostProcessor((SingletonSupplier<MetricsRepositoryMethodInvocationListener>)SingletonSupplier.of(() -> metricsRepositoryMethodInvocationListener.getObject()));
    }
}

