/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class DevToolHomePropertiesPostProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private static final String FILE_NAME = ".spring-boot-devtools.properties";
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.environment instanceof ConfigurableEnvironment) {
            try {
                this.postProcessEnvironment((ConfigurableEnvironment)this.environment);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to load .spring-boot-devtools.properties", ex);
            }
        }
    }

    private void postProcessEnvironment(ConfigurableEnvironment environment) throws IOException {
        File propertyFile;
        File home = this.getHomeFolder();
        File file = propertyFile = home == null ? null : new File(home, FILE_NAME);
        if (propertyFile != null && propertyFile.exists() && propertyFile.isFile()) {
            FileSystemResource resource = new FileSystemResource(propertyFile);
            Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
            environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("devtools-local", properties));
        }
    }

    protected File getHomeFolder() {
        String home = System.getProperty("user.home");
        if (StringUtils.hasLength((String)home)) {
            return new File(home);
        }
        return null;
    }
}

