/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

class DevToolsPropertyDefaultsPostProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private static final Map<String, Object> PROPERTIES;
    private Environment environment;

    DevToolsPropertyDefaultsPostProcessor() {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.environment instanceof ConfigurableEnvironment) {
            this.postProcessEnvironment((ConfigurableEnvironment)this.environment);
        }
    }

    private void postProcessEnvironment(ConfigurableEnvironment environment) {
        MapPropertySource propertySource = new MapPropertySource("refresh", PROPERTIES);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    static {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.thymeleaf.cache", "false");
        properties.put("spring.freemarker.cache", "false");
        properties.put("spring.groovy.template.cache", "false");
        properties.put("spring.velocity.cache", "false");
        properties.put("spring.mustache.cache", "false");
        PROPERTIES = Collections.unmodifiableMap(properties);
    }
}

