/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.filewatch;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.devtools.filewatch.ChangedFile;
import org.springframework.boot.devtools.filewatch.ChangedFiles;
import org.springframework.boot.devtools.filewatch.FileSnapshot;
import org.springframework.util.Assert;

class FolderSnapshot {
    private static final Set<String> DOT_FOLDERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".", "..")));
    private final File folder;
    private final Date time;
    private Set<FileSnapshot> files;

    public FolderSnapshot(File folder) {
        Assert.notNull((Object)folder, (String)"Folder must not be null");
        Assert.isTrue((boolean)folder.isDirectory(), (String)"Folder must not be a file");
        this.folder = folder;
        this.time = new Date();
        LinkedHashSet<FileSnapshot> files = new LinkedHashSet<FileSnapshot>();
        this.collectFiles(folder, files);
        this.files = Collections.unmodifiableSet(files);
    }

    private void collectFiles(File source, Set<FileSnapshot> result) {
        File[] children = source.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory() && !DOT_FOLDERS.contains(child.getName())) {
                    this.collectFiles(child, result);
                    continue;
                }
                if (!child.isFile()) continue;
                result.add(new FileSnapshot(child));
            }
        }
    }

    public ChangedFiles getChangedFiles(FolderSnapshot snapshot, FileFilter triggerFilter) {
        Assert.notNull((Object)snapshot, (String)"Snapshot must not be null");
        File folder = this.folder;
        Assert.isTrue((boolean)snapshot.folder.equals(folder), (String)("Snapshot source folder must be '" + folder + "'"));
        LinkedHashSet<ChangedFile> changes = new LinkedHashSet<ChangedFile>();
        Map<File, FileSnapshot> previousFiles = this.getFilesMap();
        for (FileSnapshot currentFile : snapshot.files) {
            if (!this.acceptChangedFile(triggerFilter, currentFile)) continue;
            FileSnapshot previousFile = previousFiles.remove(currentFile.getFile());
            if (previousFile == null) {
                changes.add(new ChangedFile(folder, currentFile.getFile(), ChangedFile.Type.ADD));
                continue;
            }
            if (previousFile.equals(currentFile)) continue;
            changes.add(new ChangedFile(folder, currentFile.getFile(), ChangedFile.Type.MODIFY));
        }
        for (FileSnapshot previousFile : previousFiles.values()) {
            if (!this.acceptChangedFile(triggerFilter, previousFile)) continue;
            changes.add(new ChangedFile(folder, previousFile.getFile(), ChangedFile.Type.DELETE));
        }
        return new ChangedFiles(folder, changes);
    }

    private boolean acceptChangedFile(FileFilter triggerFilter, FileSnapshot file) {
        return triggerFilter == null || !triggerFilter.accept(file.getFile());
    }

    private Map<File, FileSnapshot> getFilesMap() {
        LinkedHashMap<File, FileSnapshot> files = new LinkedHashMap<File, FileSnapshot>();
        for (FileSnapshot file : this.files) {
            files.put(file.getFile(), file);
        }
        return files;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof FolderSnapshot) {
            return this.equals((FolderSnapshot)obj, null);
        }
        return super.equals(obj);
    }

    public boolean equals(FolderSnapshot other, FileFilter filter) {
        if (this.folder.equals(other.folder)) {
            Set<FileSnapshot> ourFiles = this.filter(this.files, filter);
            Set<FileSnapshot> otherFiles = this.filter(other.files, filter);
            return ourFiles.equals(otherFiles);
        }
        return false;
    }

    private Set<FileSnapshot> filter(Set<FileSnapshot> source, FileFilter filter) {
        if (filter == null) {
            return source;
        }
        LinkedHashSet<FileSnapshot> filtered = new LinkedHashSet<FileSnapshot>();
        for (FileSnapshot file : source) {
            if (!filter.accept(file.getFile())) continue;
            filtered.add(file);
        }
        return filtered;
    }

    public int hashCode() {
        int hashCode = this.folder.hashCode();
        hashCode = 31 * hashCode + this.files.hashCode();
        return hashCode;
    }

    public File getFolder() {
        return this.folder;
    }

    public String toString() {
        return this.folder + " snapshot at " + this.time;
    }
}

