/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class RemoteUrlPropertyExtractor
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final String NON_OPTION_ARGS = "nonOptionArgs";

    RemoteUrlPropertyExtractor() {
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        String url = environment.getProperty(NON_OPTION_ARGS);
        Assert.state((boolean)StringUtils.hasLength((String)url), (String)"No remote URL specified");
        Assert.state((url.indexOf(",") == -1 ? 1 : 0) != 0, (String)"Multiple URLs specified");
        try {
            new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Malformed URL '" + url + "'");
        }
        Map<String, String> source = Collections.singletonMap("remoteUrl", url);
        MapPropertySource propertySource = new MapPropertySource("remoteUrl", source);
        environment.getPropertySources().addLast((PropertySource)propertySource);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

