/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.tunnel.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.devtools.tunnel.client.TunnelClientListener;
import org.springframework.boot.devtools.tunnel.client.TunnelClientListeners;
import org.springframework.boot.devtools.tunnel.client.TunnelConnection;
import org.springframework.util.Assert;

public class TunnelClient
implements SmartInitializingSingleton {
    private static final int BUFFER_SIZE = 102400;
    private static final Log logger = LogFactory.getLog(TunnelClient.class);
    private final int listenPort;
    private final TunnelConnection tunnelConnection;
    private TunnelClientListeners listeners = new TunnelClientListeners();
    private ServerThread serverThread;

    public TunnelClient(int listenPort, TunnelConnection tunnelConnection) {
        Assert.isTrue((listenPort > 0 ? 1 : 0) != 0, (String)"ListenPort must be positive");
        Assert.notNull((Object)tunnelConnection, (String)"TunnelConnection must not be null");
        this.listenPort = listenPort;
        this.tunnelConnection = tunnelConnection;
    }

    public void afterSingletonsInstantiated() {
        if (this.serverThread == null) {
            try {
                this.start();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public synchronized void start() throws IOException {
        Assert.state((this.serverThread == null ? 1 : 0) != 0, (String)"Server already started");
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(new InetSocketAddress(this.listenPort));
        logger.trace((Object)("Listening for TCP traffic to tunnel on port " + this.listenPort));
        this.serverThread = new ServerThread(serverSocketChannel);
        this.serverThread.start();
    }

    public synchronized void stop() throws IOException {
        if (this.serverThread != null) {
            logger.trace((Object)("Closing tunnel client on port " + this.listenPort));
            this.serverThread.close();
            try {
                this.serverThread.join(2000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.serverThread = null;
        }
    }

    protected final ServerThread getServerThread() {
        return this.serverThread;
    }

    public void addListener(TunnelClientListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(TunnelClientListener listener) {
        this.listeners.removeListener(listener);
    }

    private class SocketCloseable
    implements Closeable {
        private final SocketChannel socketChannel;
        private boolean closed = false;

        SocketCloseable(SocketChannel socketChannel) {
            this.socketChannel = socketChannel;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.socketChannel.close();
                TunnelClient.this.listeners.fireCloseEvent(this.socketChannel);
                this.closed = true;
            }
        }
    }

    protected class ServerThread
    extends Thread {
        private final ServerSocketChannel serverSocketChannel;
        private boolean acceptConnections = true;

        public ServerThread(ServerSocketChannel serverSocketChannel) {
            this.serverSocketChannel = serverSocketChannel;
            this.setName("Tunnel Server");
            this.setDaemon(true);
        }

        public void close() throws IOException {
            this.serverSocketChannel.close();
            this.acceptConnections = false;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                while (this.acceptConnections) {
                    SocketChannel socket = this.serverSocketChannel.accept();
                    try {
                        this.handleConnection(socket);
                    }
                    catch (AsynchronousCloseException asynchronousCloseException) {}
                    continue;
                    finally {
                        socket.close();
                    }
                }
            }
            catch (Exception ex) {
                logger.trace((Object)"Unexpected exception from tunnel client", (Throwable)ex);
            }
        }

        private void handleConnection(SocketChannel socketChannel) throws Exception {
            SocketCloseable closeable = new SocketCloseable(socketChannel);
            WritableByteChannel outputChannel = TunnelClient.this.tunnelConnection.open(socketChannel, closeable);
            TunnelClient.this.listeners.fireOpenEvent(socketChannel);
            try {
                logger.trace((Object)("Accepted connection to tunnel client from " + socketChannel.socket().getRemoteSocketAddress()));
                while (true) {
                    ByteBuffer buffer;
                    int amountRead;
                    if ((amountRead = socketChannel.read(buffer = ByteBuffer.allocate(102400))) == -1) {
                        outputChannel.close();
                        return;
                    }
                    if (amountRead <= 0) continue;
                    buffer.flip();
                    outputChannel.write(buffer);
                }
            }
            finally {
                outputChannel.close();
            }
        }

        protected void stopAcceptingConnections() {
            this.acceptConnections = false;
        }
    }
}

