/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class HateoasObjenesisCacheDisabler
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(HateoasObjenesisCacheDisabler.class);
    private static boolean cacheDisabled;

    HateoasObjenesisCacheDisabler() {
    }

    public void afterPropertiesSet() {
        this.disableCaching();
    }

    private void disableCaching() {
        if (!cacheDisabled) {
            cacheDisabled = true;
            this.doDisableCaching();
        }
    }

    private void doDisableCaching() {
        try {
            Class type = ClassUtils.forName((String)"org.springframework.hateoas.server.core.DummyInvocationUtils", (ClassLoader)this.getClass().getClassLoader());
            this.removeObjenesisCache(type);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeObjenesisCache(Class<?> dummyInvocationUtils) {
        try {
            Field objenesisField = ReflectionUtils.findField(dummyInvocationUtils, (String)"OBJENESIS");
            if (objenesisField != null) {
                ReflectionUtils.makeAccessible((Field)objenesisField);
                Object objenesis = ReflectionUtils.getField((Field)objenesisField, null);
                Field cacheField = ReflectionUtils.findField(objenesis.getClass(), (String)"cache");
                ReflectionUtils.makeAccessible((Field)cacheField);
                ReflectionUtils.setField((Field)cacheField, (Object)objenesis, null);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"Failed to disable Spring HATEOAS's Objenesis cache. ClassCastExceptions may occur", (Throwable)ex);
        }
    }
}

