/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.run;

import java.io.File;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskAction;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.loader.tools.MainClassFinder;

public class FindMainClassTask
extends DefaultTask {
    @Input
    private SourceSetOutput mainClassSourceSetOutput;

    public void setMainClassSourceSetOutput(SourceSetOutput sourceSetOutput) {
        this.mainClassSourceSetOutput = sourceSetOutput;
        this.dependsOn(new Object[]{this.mainClassSourceSetOutput.getBuildDependencies()});
    }

    @TaskAction
    public void setMainClassNameProperty() {
        Project project = this.getProject();
        if (!project.hasProperty("mainClassName") || project.property("mainClassName") == null) {
            String mainClass = this.findMainClass();
            if (project.hasProperty("mainClassName")) {
                project.setProperty("mainClassName", (Object)mainClass);
            } else {
                ExtraPropertiesExtension extraProperties = (ExtraPropertiesExtension)project.getExtensions().getByName("ext");
                extraProperties.set("mainClassName", (Object)mainClass);
            }
        }
    }

    private String findMainClass() {
        Task bootRunTask;
        Project project = this.getProject();
        String mainClass = null;
        SpringBootPluginExtension bootExtension = (SpringBootPluginExtension)project.getExtensions().getByType(SpringBootPluginExtension.class);
        if (bootExtension.getMainClass() != null) {
            mainClass = bootExtension.getMainClass();
        }
        ApplicationPluginConvention application = (ApplicationPluginConvention)project.getConvention().getPlugins().get("application");
        if (mainClass == null && application != null) {
            mainClass = application.getMainClassName();
        }
        JavaExec runTask = this.findRunTask(project);
        if (mainClass == null && runTask != null) {
            mainClass = runTask.getMain();
        }
        if (mainClass == null && (bootRunTask = (Task)project.getTasks().findByName("bootRun")) != null) {
            mainClass = (String)bootRunTask.property("main");
        }
        if (mainClass == null && this.mainClassSourceSetOutput != null) {
            project.getLogger().debug("Looking for main in: " + this.mainClassSourceSetOutput.getClassesDir());
            try {
                mainClass = MainClassFinder.findSingleMainClass((File)this.mainClassSourceSetOutput.getClassesDir());
                project.getLogger().info("Computed main class: " + mainClass);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot find main class", ex);
            }
        }
        project.getLogger().info("Found main: " + mainClass);
        if (bootExtension.getMainClass() == null) {
            bootExtension.setMainClass(mainClass);
        }
        if (application != null && application.getMainClassName() == null) {
            application.setMainClassName(mainClass);
        }
        if (runTask != null && !runTask.hasProperty("main")) {
            runTask.setMain(mainClass);
        }
        return mainClass;
    }

    private JavaExec findRunTask(Project project) {
        Task runTask = (Task)project.getTasks().findByName("run");
        if (runTask instanceof JavaExec) {
            return (JavaExec)runTask;
        }
        return null;
    }
}

