/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.springframework.boot.gradle.plugin.MainClassConvention;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.tasks.bundling.BootWar;

class WarPluginAction
implements PluginApplicationAction {
    private final SinglePublishedArtifact singlePublishedArtifact;

    WarPluginAction(SinglePublishedArtifact singlePublishedArtifact) {
        this.singlePublishedArtifact = singlePublishedArtifact;
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return WarPlugin.class;
    }

    public void execute(Project project) {
        project.getTasks().getByName("war").setEnabled(false);
        BootWar bootWar = (BootWar)project.getTasks().create("bootWar", BootWar.class);
        bootWar.setGroup("build");
        bootWar.setDescription("Assembles an executable war archive containing webapp content, and the main classes and their dependencies.");
        bootWar.providedClasspath(this.providedRuntimeConfiguration(project));
        ArchivePublishArtifact artifact = new ArchivePublishArtifact((AbstractArchiveTask)bootWar);
        this.singlePublishedArtifact.addCandidate((PublishArtifact)artifact);
        bootWar.conventionMapping("mainClass", new MainClassConvention(project, () -> ((BootWar)bootWar).getClasspath()));
    }

    private Configuration providedRuntimeConfiguration(Project project) {
        return project.getConfigurations().getByName("providedRuntime");
    }
}

