/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.tasks.bundling.BootArchive;
import org.springframework.boot.gradle.tasks.bundling.BootArchiveSupport;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;

public class BootJar
extends Jar
implements BootArchive {
    private BootArchiveSupport support = new BootArchiveSupport("org.springframework.boot.loader.JarLauncher", this::resolveZipCompression);
    private FileCollection classpath;
    private String mainClassName;

    public BootJar() {
        CopySpec bootInf = this.getRootSpec().addChildBeforeSpec(this.getMainSpec()).into((Object)"BOOT-INF");
        bootInf.into((Object)"lib", this.classpathFiles((Spec<File>)((Spec)File::isFile)));
        bootInf.into((Object)"classes", this.classpathFiles((Spec<File>)((Spec)File::isDirectory)));
    }

    private Action<CopySpec> classpathFiles(Spec<File> filter) {
        return copySpec -> copySpec.from(new Object[]{() -> this.classpath == null ? Collections.emptyList() : this.classpath.filter(filter)});
    }

    public void copy() {
        this.support.configureManifest(this, this.getMainClassName());
        super.copy();
    }

    protected CopyAction createCopyAction() {
        return this.support.createCopyAction(this);
    }

    @Override
    public String getMainClassName() {
        return this.mainClassName;
    }

    @Override
    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    @Override
    public void requiresUnpack(String ... patterns) {
        this.support.requiresUnpack(patterns);
    }

    @Override
    public void requiresUnpack(Spec<FileTreeElement> spec) {
        this.support.requiresUnpack(spec);
    }

    @Override
    public LaunchScriptConfiguration getLaunchScript() {
        return this.support.getLaunchScript();
    }

    @Override
    public void launchScript() {
        this.enableLaunchScriptIfNecessary();
    }

    @Override
    public void launchScript(Action<LaunchScriptConfiguration> action) {
        action.execute((Object)this.enableLaunchScriptIfNecessary());
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public void classpath(Object ... classpath) {
        FileCollection existingClasspath = this.classpath;
        this.classpath = this.getProject().files(new Object[]{existingClasspath == null ? Collections.emptyList() : existingClasspath, classpath});
    }

    @Override
    public boolean isExcludeDevtools() {
        return this.support.isExcludeDevtools();
    }

    @Override
    public void setExcludeDevtools(boolean excludeDevtools) {
        this.support.setExcludeDevtools(excludeDevtools);
    }

    protected ZipCompression resolveZipCompression(FileCopyDetails details) {
        if (details.getRelativePath().getPathString().startsWith("BOOT-INF/lib/")) {
            return ZipCompression.STORED;
        }
        return ZipCompression.DEFLATED;
    }

    private LaunchScriptConfiguration enableLaunchScriptIfNecessary() {
        LaunchScriptConfiguration launchScript = this.support.getLaunchScript();
        if (launchScript == null) {
            launchScript = new LaunchScriptConfiguration();
            this.support.setLaunchScript(launchScript);
        }
        return launchScript;
    }
}

