/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import org.cyclonedx.gradle.CycloneDxPlugin;
import org.cyclonedx.gradle.CycloneDxTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SpringBootPlugin;
import org.springframework.boot.gradle.tasks.bundling.BootJar;
import org.springframework.boot.gradle.tasks.bundling.BootWar;

final class CycloneDxPluginAction
implements PluginApplicationAction {
    CycloneDxPluginAction() {
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return CycloneDxPlugin.class;
    }

    public void execute(Project project) {
        TaskProvider cycloneDxTaskProvider = project.getTasks().named("cyclonedxBom", CycloneDxTask.class);
        this.configureCycloneDxTask((TaskProvider<CycloneDxTask>)cycloneDxTaskProvider);
        this.configureJavaPlugin(project, (TaskProvider<CycloneDxTask>)cycloneDxTaskProvider);
        this.configureSpringBootPlugin(project, (TaskProvider<CycloneDxTask>)cycloneDxTaskProvider);
    }

    private void configureCycloneDxTask(TaskProvider<CycloneDxTask> taskProvider) {
        taskProvider.configure(task -> {
            task.getProjectType().convention((Object)"application");
            task.getOutputFormat().convention((Object)"json");
            task.getOutputName().convention((Object)"application.cdx");
            task.getIncludeLicenseText().convention((Object)false);
        });
    }

    private void configureJavaPlugin(Project project, TaskProvider<CycloneDxTask> cycloneDxTaskProvider) {
        this.configurePlugin(project, JavaPlugin.class, javaPlugin -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            SourceSet main = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
            this.configureTask(project, main.getProcessResourcesTaskName(), Copy.class, copy -> {
                copy.dependsOn(new Object[]{cycloneDxTaskProvider});
                Provider sbomFileName = cycloneDxTaskProvider.map(cycloneDxTask -> (String)cycloneDxTask.getOutputName().get() + this.getSbomExtension((CycloneDxTask)cycloneDxTask));
                copy.from((Object)cycloneDxTaskProvider, spec -> spec.include(new String[]{(String)sbomFileName.get()}).into((Object)"META-INF/sbom"));
            });
        });
    }

    private void configureSpringBootPlugin(Project project, TaskProvider<CycloneDxTask> cycloneDxTaskProvider) {
        this.configurePlugin(project, SpringBootPlugin.class, springBootPlugin -> {
            this.configureBootJarTask(project, cycloneDxTaskProvider);
            this.configureBootWarTask(project, cycloneDxTaskProvider);
        });
    }

    private void configureBootJarTask(Project project, TaskProvider<CycloneDxTask> cycloneDxTaskProvider) {
        this.configureTask(project, "bootJar", BootJar.class, bootJar -> this.configureBootJarTask((BootJar)bootJar, cycloneDxTaskProvider));
    }

    private void configureBootWarTask(Project project, TaskProvider<CycloneDxTask> cycloneDxTaskProvider) {
        this.configureTask(project, "bootWar", BootWar.class, bootWar -> this.configureBootWarTask((BootWar)bootWar, cycloneDxTaskProvider));
    }

    private void configureBootJarTask(BootJar task, TaskProvider<CycloneDxTask> cycloneDxTaskProvider) {
        this.configureJarTask(task, cycloneDxTaskProvider);
    }

    private void configureBootWarTask(BootWar task, TaskProvider<CycloneDxTask> cycloneDxTaskProvider) {
        this.configureJarTask((Jar)task, cycloneDxTaskProvider);
    }

    private void configureJarTask(Jar task, TaskProvider<CycloneDxTask> cycloneDxTaskProvider) {
        Provider sbomFileName = cycloneDxTaskProvider.map(cycloneDxTask -> "META-INF/sbom/" + (String)cycloneDxTask.getOutputName().get() + this.getSbomExtension((CycloneDxTask)cycloneDxTask));
        task.manifest(manifest -> {
            manifest.getAttributes().put((Object)"Sbom-Format", (Object)"CycloneDX");
            manifest.getAttributes().put((Object)"Sbom-Location", (Object)sbomFileName);
        });
    }

    private String getSbomExtension(CycloneDxTask task) {
        String format = (String)task.getOutputFormat().get();
        if ("all".equals(format)) {
            return ".json";
        }
        return "." + format;
    }

    private <T extends Task> void configureTask(Project project, String name, Class<T> type, Action<T> action) {
        project.getTasks().withType(type).configureEach(task -> {
            if (task.getName().equals(name)) {
                action.execute(task);
            }
        });
    }

    private <T extends Plugin<?>> void configurePlugin(Project project, Class<T> plugin, Action<T> action) {
        project.getPlugins().withType(plugin, action);
    }
}

