/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;

public class CompositeDataSourcePoolMetadataProvider
implements DataSourcePoolMetadataProvider {
    private final List<DataSourcePoolMetadataProvider> providers;

    public CompositeDataSourcePoolMetadataProvider(@Nullable Collection<? extends DataSourcePoolMetadataProvider> providers) {
        this.providers = providers != null ? List.copyOf(providers) : Collections.emptyList();
    }

    @Override
    public @Nullable DataSourcePoolMetadata getDataSourcePoolMetadata(DataSource dataSource) {
        for (DataSourcePoolMetadataProvider provider : this.providers) {
            DataSourcePoolMetadata metadata = provider.getDataSourcePoolMetadata(dataSource);
            if (metadata == null) continue;
            return metadata;
        }
        return null;
    }
}

