/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Repackager;
import org.springframework.boot.maven.ArtifactsLibraries;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter
    private String classifier;
    @Parameter
    private String mainClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File source = this.project.getArtifact().getFile();
        File target = this.getTargetFile();
        Repackager repackager = new Repackager(source);
        repackager.setMainClass(this.mainClass);
        ArtifactsLibraries libraries = new ArtifactsLibraries(this.project.getArtifacts());
        try {
            repackager.repackage(target, (Libraries)libraries);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        if (!source.equals(target)) {
            this.getLog().info((CharSequence)("Attaching archive: " + target + ", with classifier: " + this.classifier));
            this.projectHelper.attachArtifact(this.project, this.project.getPackaging(), this.classifier, target);
        }
    }

    private File getTargetFile() {
        String classifier;
        String string = classifier = this.classifier == null ? "" : this.classifier.trim();
        if (classifier.length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(this.outputDirectory, this.finalName + classifier + "." + this.project.getPackaging());
    }
}

