/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;

public class ArtifactsLibraries
implements Libraries {
    private static final Set<String> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("jar", "ejb", "ejb-client", "test-jar", "bundle")));
    private static final Map<String, LibraryScope> SCOPES;
    private final Set<Artifact> artifacts;

    public ArtifactsLibraries(Set<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        for (Artifact artifact : this.artifacts) {
            LibraryScope scope;
            if (!SUPPORTED_TYPES.contains(artifact.getType()) || (scope = SCOPES.get(artifact.getScope())) == null || artifact.getFile() == null) continue;
            callback.library(artifact.getFile(), scope);
        }
    }

    static {
        HashMap<String, LibraryScope> scopes = new HashMap<String, LibraryScope>();
        scopes.put("compile", LibraryScope.COMPILE);
        scopes.put("runtime", LibraryScope.RUNTIME);
        scopes.put("provided", LibraryScope.PROVIDED);
        SCOPES = Collections.unmodifiableMap(scopes);
    }
}

