/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.artifact.Artifact;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.ImageName;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.boot.maven.CacheInfo;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class Image {
    String name;
    String builder;
    Boolean trustBuilder;
    String runImage;
    Map<String, String> env;
    Boolean cleanCache;
    boolean verboseLogging;
    PullPolicy pullPolicy;
    Boolean publish;
    List<String> buildpacks;
    List<String> bindings;
    String network;
    List<String> tags;
    CacheInfo buildWorkspace;
    CacheInfo buildCache;
    CacheInfo launchCache;
    String createdDate;
    String applicationDirectory;
    List<String> securityOptions;
    String imagePlatform;

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getBuilder() {
        return this.builder;
    }

    void setBuilder(String builder) {
        this.builder = builder;
    }

    public Boolean getTrustBuilder() {
        return this.trustBuilder;
    }

    void setTrustBuilder(Boolean trustBuilder) {
        this.trustBuilder = trustBuilder;
    }

    public String getRunImage() {
        return this.runImage;
    }

    void setRunImage(String runImage) {
        this.runImage = runImage;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Boolean getCleanCache() {
        return this.cleanCache;
    }

    void setCleanCache(Boolean cleanCache) {
        this.cleanCache = cleanCache;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    void setPullPolicy(PullPolicy pullPolicy) {
        this.pullPolicy = pullPolicy;
    }

    public Boolean getPublish() {
        return this.publish;
    }

    void setPublish(Boolean publish) {
        this.publish = publish;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public String getApplicationDirectory() {
        return this.applicationDirectory;
    }

    public void setApplicationDirectory(String applicationDirectory) {
        this.applicationDirectory = applicationDirectory;
    }

    public String getImagePlatform() {
        return this.imagePlatform;
    }

    public void setImagePlatform(String imagePlatform) {
        this.imagePlatform = imagePlatform;
    }

    BuildRequest getBuildRequest(Artifact artifact, Function<Owner, TarArchive> applicationContent) {
        return this.customize(BuildRequest.of((ImageReference)this.getOrDeduceName(artifact), applicationContent));
    }

    private ImageReference getOrDeduceName(Artifact artifact) {
        if (StringUtils.hasText((String)this.name)) {
            return ImageReference.of((String)this.name);
        }
        ImageName imageName = ImageName.of((String)artifact.getArtifactId());
        return ImageReference.of((ImageName)imageName, (String)artifact.getVersion());
    }

    private BuildRequest customize(BuildRequest request) {
        if (StringUtils.hasText((String)this.builder)) {
            request = request.withBuilder(ImageReference.of((String)this.builder));
        }
        if (this.trustBuilder != null) {
            request = request.withTrustBuilder(this.trustBuilder.booleanValue());
        }
        if (StringUtils.hasText((String)this.runImage)) {
            request = request.withRunImage(ImageReference.of((String)this.runImage));
        }
        if (!CollectionUtils.isEmpty(this.env)) {
            request = request.withEnv(this.env);
        }
        if (this.cleanCache != null) {
            request = request.withCleanCache(this.cleanCache.booleanValue());
        }
        request = request.withVerboseLogging(this.verboseLogging);
        if (this.pullPolicy != null) {
            request = request.withPullPolicy(this.pullPolicy);
        }
        if (this.publish != null) {
            request = request.withPublish(this.publish.booleanValue());
        }
        if (!CollectionUtils.isEmpty(this.buildpacks)) {
            request = request.withBuildpacks(this.buildpacks.stream().map(BuildpackReference::of).toList());
        }
        if (!CollectionUtils.isEmpty(this.bindings)) {
            request = request.withBindings(this.bindings.stream().map(Binding::of).toList());
        }
        request = request.withNetwork(this.network);
        if (!CollectionUtils.isEmpty(this.tags)) {
            request = request.withTags(this.tags.stream().map(ImageReference::of).toList());
        }
        if (this.buildWorkspace != null) {
            request = request.withBuildWorkspace(this.buildWorkspace.asCache());
        }
        if (this.buildCache != null) {
            request = request.withBuildCache(this.buildCache.asCache());
        }
        if (this.launchCache != null) {
            request = request.withLaunchCache(this.launchCache.asCache());
        }
        if (StringUtils.hasText((String)this.createdDate)) {
            request = request.withCreatedDate(this.createdDate);
        }
        if (StringUtils.hasText((String)this.applicationDirectory)) {
            request = request.withApplicationDirectory(this.applicationDirectory);
        }
        if (this.securityOptions != null) {
            request = request.withSecurityOptions(this.securityOptions);
        }
        if (StringUtils.hasText((String)this.imagePlatform)) {
            request = request.withImagePlatform(this.imagePlatform);
        }
        return request;
    }
}

