/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.metrics.testcontainers.otlp;

import org.springframework.boot.metrics.autoconfigure.export.otlp.OtlpMetricsConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.grafana.LgtmStackContainer;

class GrafanaOpenTelemetryMetricsContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LgtmStackContainer, OtlpMetricsConnectionDetails> {
    GrafanaOpenTelemetryMetricsContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{"org.springframework.boot.metrics.autoconfigure.export.otlp.OtlpMetricsExportAutoConfiguration"});
    }

    protected OtlpMetricsConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
        return new OpenTelemetryMetricsContainerConnectionDetails(source);
    }

    private static final class OpenTelemetryMetricsContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LgtmStackContainer>
    implements OtlpMetricsConnectionDetails {
        private OpenTelemetryMetricsContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
            super(source);
        }

        @Override
        public String getUrl() {
            return "%s/v1/metrics".formatted(((LgtmStackContainer)this.getContainer()).getOtlpHttpUrl());
        }
    }
}

