/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.observation.autoconfigure;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.observation.autoconfigure.ObservationHandlerGroup;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;

class ObservationHandlerGroups {
    private final List<ObservationHandlerGroup> groups;

    ObservationHandlerGroups(Collection<? extends ObservationHandlerGroup> groups) {
        this.groups = Collections.unmodifiableList(ObservationHandlerGroups.sort(groups));
    }

    private static List<ObservationHandlerGroup> sort(Collection<? extends ObservationHandlerGroup> groups) {
        ArrayList<ObservationHandlerGroup> sortedGroups = new ArrayList<ObservationHandlerGroup>(groups);
        Collections.sort(sortedGroups);
        return sortedGroups;
    }

    void register(ObservationRegistry.ObservationConfig config, List<ObservationHandler<?>> handlers) {
        LinkedMultiValueMap grouped = new LinkedMultiValueMap();
        for (ObservationHandler<?> handler : handlers) {
            grouped.add((Object)this.findGroup(handler), handler);
        }
        for (ObservationHandlerGroup group : this.groups) {
            List members = (List)grouped.get((Object)group);
            if (CollectionUtils.isEmpty((Collection)members)) continue;
            group.registerMembers(config, members);
        }
        List unclaimed = (List)grouped.get(null);
        if (!CollectionUtils.isEmpty((Collection)unclaimed)) {
            for (ObservationHandler handler : unclaimed) {
                config.observationHandler(handler);
            }
        }
    }

    private ObservationHandlerGroup findGroup(ObservationHandler<?> handler) {
        for (ObservationHandlerGroup group : this.groups) {
            if (!group.isMember(handler)) continue;
            return group;
        }
        return null;
    }
}

