/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.test.autoconfigure.json.AutoConfigureJsonTesters;
import org.springframework.boot.test.json.BasicJsonTester;
import org.springframework.boot.test.json.GsonTester;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class JsonTesterInitializationTestExecutionListener
extends AbstractTestExecutionListener {
    private static final String ASSERTJ_CLASS = "org.assertj.core.api.Assert";
    private static final Map<String, Class<?>> INITIALIZERS;

    public void prepareTestInstance(TestContext testContext) throws Exception {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (ClassUtils.isPresent((String)ASSERTJ_CLASS, (ClassLoader)classLoader) && this.shouldInitializeFields(testContext)) {
            this.initializeBasicJsonTesterFields(testContext);
            this.initializeJsonMarshalTesterFields(classLoader, testContext);
        }
    }

    private boolean shouldInitializeFields(TestContext testContext) {
        AutoConfigureJsonTesters annotation = (AutoConfigureJsonTesters)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)testContext.getTestClass(), AutoConfigureJsonTesters.class);
        return annotation != null && annotation.initFields();
    }

    private void initializeBasicJsonTesterFields(final TestContext testContext) {
        ReflectionUtils.doWithFields((Class)testContext.getTestClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (BasicJsonTester.class.isAssignableFrom(field.getType())) {
                    this.setupField(field);
                }
            }

            private void setupField(Field field) {
                ReflectionUtils.makeAccessible((Field)field);
                Object existingInstance = ReflectionUtils.getField((Field)field, (Object)testContext.getTestInstance());
                if (existingInstance == null) {
                    ReflectionUtils.setField((Field)field, (Object)testContext.getTestInstance(), (Object)new BasicJsonTester(testContext.getTestClass()));
                }
            }
        });
    }

    private void initializeJsonMarshalTesterFields(ClassLoader classLoader, TestContext testContext) {
        for (Map.Entry<String, Class<?>> entry : INITIALIZERS.entrySet()) {
            if (!ClassUtils.isPresent((String)entry.getKey(), (ClassLoader)classLoader)) continue;
            this.initializeJsonMarshalTesterFields(classLoader, testContext, entry.getKey(), entry.getValue());
        }
    }

    private void initializeJsonMarshalTesterFields(ClassLoader classLoader, TestContext testContext, String marshallerClassName, Class<?> initializer) {
        try {
            Constructor<?> constructor = initializer.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(constructor);
            this.initializeJsonMarshalTesterFields(testContext, ClassUtils.resolveClassName((String)marshallerClassName, (ClassLoader)classLoader), (Initializer)constructor.newInstance(new Object[0]));
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    private <T> void initializeJsonMarshalTesterFields(final TestContext testContext, final Class<T> marshallerClass, Initializer<T> initializer) {
        initializer.initialize(testContext, new ObjectFactory<T>(){

            public T getObject() throws BeansException {
                return testContext.getApplicationContext().getBean(marshallerClass);
            }
        });
    }

    static {
        LinkedHashMap<String, Class> initializers = new LinkedHashMap<String, Class>();
        initializers.put("com.fasterxml.jackson.databind.ObjectMapper", JacksonInitializer.class);
        initializers.put("com.google.gson.Gson", GsonInitializer.class);
        INITIALIZERS = Collections.unmodifiableMap(initializers);
    }

    static class GsonInitializer
    implements Initializer<Gson> {
        GsonInitializer() {
        }

        @Override
        public void initialize(TestContext testContext, ObjectFactory<Gson> marshaller) {
            GsonTester.initFields((Object)testContext.getTestInstance(), marshaller);
        }
    }

    static class JacksonInitializer
    implements Initializer<ObjectMapper> {
        JacksonInitializer() {
        }

        @Override
        public void initialize(TestContext testContext, ObjectFactory<ObjectMapper> marshaller) {
            JacksonTester.initFields((Object)testContext.getTestInstance(), marshaller);
        }
    }

    static interface Initializer<M> {
        public void initialize(TestContext var1, ObjectFactory<M> var2);
    }
}

