/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import java.io.OutputStream;
import java.util.Collection;
import javax.servlet.Filter;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcBuilderCustomizer;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletContextInitializerBeans;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class SpringBootMockMvcBuilderCustomizer
implements MockMvcBuilderCustomizer {
    private final WebApplicationContext context;
    private boolean addFilters = true;
    private boolean alwaysPrint = true;

    public SpringBootMockMvcBuilderCustomizer(WebApplicationContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        this.context = context;
    }

    @Override
    public void customize(ConfigurableMockMvcBuilder<?> builder) {
        if (this.addFilters) {
            this.addFilters(builder);
        }
        if (this.alwaysPrint) {
            builder.alwaysDo(MockMvcResultHandlers.print((OutputStream)System.out));
        }
    }

    private void addFilters(ConfigurableMockMvcBuilder<?> builder) {
        ServletContextInitializerBeans Initializers = new ServletContextInitializerBeans((ListableBeanFactory)this.context);
        for (ServletContextInitializer initializer : Initializers) {
            if (initializer instanceof FilterRegistrationBean) {
                this.addFilter(builder, (FilterRegistrationBean)initializer);
            }
            if (!(initializer instanceof DelegatingFilterProxyRegistrationBean)) continue;
            this.addFilter(builder, (DelegatingFilterProxyRegistrationBean)initializer);
        }
    }

    private void addFilter(ConfigurableMockMvcBuilder<?> builder, FilterRegistrationBean registration) {
        this.addFilter(builder, registration.getFilter(), registration.getUrlPatterns());
    }

    private void addFilter(ConfigurableMockMvcBuilder<?> builder, DelegatingFilterProxyRegistrationBean registration) {
        this.addFilter(builder, registration.getFilter(), registration.getUrlPatterns());
    }

    private void addFilter(ConfigurableMockMvcBuilder<?> builder, Filter filter, Collection<String> urls) {
        if (urls.isEmpty()) {
            builder.addFilters(new Filter[]{filter});
        } else {
            builder.addFilter(filter, urls.toArray(new String[urls.size()]));
        }
    }

    public void setAddFilters(boolean addFilters) {
        this.addFilters = addFilters;
    }

    public boolean isAddFilters() {
        return this.addFilters;
    }

    public void setAlwaysPrint(boolean alwaysPrint) {
        this.alwaysPrint = alwaysPrint;
    }

    public boolean isAlwaysPrint() {
        return this.alwaysPrint;
    }
}

