/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.properties;

import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.test.autoconfigure.properties.AnnotationsPropertySource;
import org.springframework.boot.test.autoconfigure.properties.PropertyMapping;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ClassUtils;

class PropertyMappingContextCustomizer
implements ContextCustomizer {
    private final AnnotationsPropertySource propertySource;

    PropertyMappingContextCustomizer(AnnotationsPropertySource propertySource) {
        this.propertySource = propertySource;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        if (!this.propertySource.isEmpty()) {
            context.getEnvironment().getPropertySources().addFirst((PropertySource)this.propertySource);
        }
        context.getBeanFactory().registerSingleton(PropertyMappingCheckBeanPostProcessor.class.getName(), (Object)new PropertyMappingCheckBeanPostProcessor());
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.propertySource.equals((Object)((PropertyMappingContextCustomizer)obj).propertySource);
    }

    public int hashCode() {
        return this.propertySource.hashCode();
    }

    static class PropertyMappingCheckBeanPostProcessor
    implements BeanPostProcessor {
        PropertyMappingCheckBeanPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            Class<?> beanClass = bean.getClass();
            MergedAnnotations annotations = MergedAnnotations.from(beanClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS);
            Set<Class<?>> components = annotations.stream(Component.class).map(this::getRoot).collect(Collectors.toSet());
            Set<Class<?>> propertyMappings = annotations.stream(PropertyMapping.class).map(this::getRoot).collect(Collectors.toSet());
            if (!components.isEmpty() && !propertyMappings.isEmpty()) {
                throw new IllegalStateException("The @PropertyMapping " + this.getAnnotationsDescription(propertyMappings) + " cannot be used in combination with the @Component " + this.getAnnotationsDescription(components));
            }
            return bean;
        }

        private Class<?> getRoot(MergedAnnotation<?> annotation) {
            while (annotation.getParent() != null) {
                annotation = annotation.getParent();
            }
            return annotation.getType();
        }

        private String getAnnotationsDescription(Set<Class<?>> annotations) {
            StringBuilder result = new StringBuilder();
            for (Class<?> annotation : annotations) {
                if (result.length() != 0) {
                    result.append(", ");
                }
                result.append('@').append(ClassUtils.getShortName(annotation));
            }
            result.insert(0, annotations.size() != 1 ? "annotations " : "annotation ");
            return result.toString();
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

