/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.boot.ansi.AnsiOutput;

public class OutputCapture
implements TestRule {
    private CaptureOutputStream captureOut;
    private CaptureOutputStream captureErr;
    private ByteArrayOutputStream copy;
    private List<Matcher<? super String>> matchers = new ArrayList<Matcher<? super String>>();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                OutputCapture.this.captureOutput();
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        if (!OutputCapture.this.matchers.isEmpty()) {
                            String output = OutputCapture.this.toString();
                            Assert.assertThat((Object)output, (Matcher)Matchers.allOf((Iterable)OutputCapture.this.matchers));
                        }
                    }
                    finally {
                        OutputCapture.this.releaseOutput();
                    }
                }
            }
        };
    }

    protected void captureOutput() {
        AnsiOutputControl.get().disableAnsiOutput();
        this.copy = new ByteArrayOutputStream();
        this.captureOut = new CaptureOutputStream(System.out, this.copy);
        this.captureErr = new CaptureOutputStream(System.err, this.copy);
        System.setOut(new PrintStream(this.captureOut));
        System.setErr(new PrintStream(this.captureErr));
    }

    protected void releaseOutput() {
        AnsiOutputControl.get().enabledAnsiOutput();
        System.setOut(this.captureOut.getOriginal());
        System.setErr(this.captureErr.getOriginal());
        this.copy = null;
    }

    public void flush() {
        try {
            this.captureOut.flush();
            this.captureErr.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        this.flush();
        return this.copy.toString();
    }

    public void expect(Matcher<? super String> matcher) {
        this.matchers.add(matcher);
    }

    private static class AnsiPresentOutputControl
    extends AnsiOutputControl {
        private AnsiPresentOutputControl() {
        }

        @Override
        public void disableAnsiOutput() {
            AnsiOutput.setEnabled((AnsiOutput.Enabled)AnsiOutput.Enabled.NEVER);
        }

        @Override
        public void enabledAnsiOutput() {
            AnsiOutput.setEnabled((AnsiOutput.Enabled)AnsiOutput.Enabled.DETECT);
        }
    }

    private static class AnsiOutputControl {
        private AnsiOutputControl() {
        }

        public void disableAnsiOutput() {
        }

        public void enabledAnsiOutput() {
        }

        public static AnsiOutputControl get() {
            try {
                Class.forName("org.springframework.boot.ansi.AnsiOutput");
                return new AnsiPresentOutputControl();
            }
            catch (ClassNotFoundException ex) {
                return new AnsiOutputControl();
            }
        }
    }

    private static class CaptureOutputStream
    extends OutputStream {
        private final PrintStream original;
        private final OutputStream copy;

        CaptureOutputStream(PrintStream original, OutputStream copy) {
            this.original = original;
            this.copy = copy;
        }

        @Override
        public void write(int b) throws IOException {
            this.copy.write(b);
            this.original.write(b);
            this.original.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.copy.write(b, off, len);
            this.original.write(b, off, len);
        }

        public PrintStream getOriginal() {
            return this.original;
        }

        @Override
        public void flush() throws IOException {
            this.copy.flush();
            this.original.flush();
        }
    }
}

