/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.LocalHostUriTemplateHandler;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.web.util.UriTemplateHandler;

class SpringBootTestContextCustomizer
implements ContextCustomizer {
    SpringBootTestContextCustomizer() {
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        SpringBootTest annotation = (SpringBootTest)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)mergedContextConfiguration.getTestClass(), SpringBootTest.class);
        if (annotation.webEnvironment().isEmbedded()) {
            this.registerTestRestTemplate(context);
        }
    }

    private void registerTestRestTemplate(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.registerTestRestTemplate(context, (BeanDefinitionRegistry)context);
        }
    }

    private void registerTestRestTemplate(ConfigurableApplicationContext context, BeanDefinitionRegistry registry) {
        registry.registerBeanDefinition("testRestTemplate", (BeanDefinition)new RootBeanDefinition(TestRestTemplateFactory.class));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public static class TestRestTemplateFactory
    implements FactoryBean<TestRestTemplate>,
    ApplicationContextAware {
        private TestRestTemplate object;

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            RestTemplateBuilder builder = this.getRestTemplateBuilder(applicationContext);
            TestRestTemplate template = new TestRestTemplate(builder.build());
            template.setUriTemplateHandler((UriTemplateHandler)new LocalHostUriTemplateHandler(applicationContext.getEnvironment()));
            this.object = template;
        }

        private RestTemplateBuilder getRestTemplateBuilder(ApplicationContext applicationContext) {
            try {
                return (RestTemplateBuilder)applicationContext.getBean(RestTemplateBuilder.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return new RestTemplateBuilder(new RestTemplateCustomizer[0]);
            }
        }

        public boolean isSingleton() {
            return true;
        }

        public Class<?> getObjectType() {
            return TestRestTemplate.class;
        }

        public TestRestTemplate getObject() throws Exception {
            return this.object;
        }
    }
}

