/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class ApplicationContextAssert<C extends ApplicationContext>
extends AbstractAssert<ApplicationContextAssert<C>, C> {
    private final Throwable startupFailure;

    ApplicationContextAssert(C applicationContext, Throwable startupFailure) {
        super(applicationContext, ApplicationContextAssert.class);
        Assert.notNull(applicationContext, (String)"ApplicationContext must not be null");
        this.startupFailure = startupFailure;
    }

    public ApplicationContextAssert<C> hasBean(String name) {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have bean named:%n <%s>%nbut context failed to start", new Object[]{this.getApplicationContext(), name}));
        }
        if (this.findBean(name) == null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have bean named:%n <%s>%nbut found no such bean", new Object[]{this.getApplicationContext(), name}));
        }
        return this;
    }

    public ApplicationContextAssert<C> hasSingleBean(Class<?> type) {
        String[] names;
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have a single bean of type:%n <%s>%nbut context failed to start", new Object[]{this.getApplicationContext(), type}));
        }
        if ((names = this.getApplicationContext().getBeanNamesForType(type)).length == 0) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have a single bean of type:%n <%s>%nbut found no beans of that type", new Object[]{this.getApplicationContext(), type}));
        }
        if (names.length > 1) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have a single bean of type:%n <%s>%nbut found:%n <%s>", new Object[]{this.getApplicationContext(), type, names}));
        }
        return this;
    }

    public ApplicationContextAssert<C> doesNotHaveBean(Class<?> type) {
        String[] names;
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nnot to have any beans of type:%n <%s>%nbut context failed to start", new Object[]{this.getApplicationContext(), type}));
        }
        if ((names = this.getApplicationContext().getBeanNamesForType(type)).length > 0) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nnot to have a beans of type:%n <%s>%nbut found:%n <%s>", new Object[]{this.getApplicationContext(), type, names}));
        }
        return this;
    }

    public ApplicationContextAssert<C> doesNotHaveBean(String name) {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nnot to have any beans of name:%n <%s>%nbut context failed to start", new Object[]{this.getApplicationContext(), name}));
        }
        try {
            Object bean = this.getApplicationContext().getBean(name);
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nnot to have a bean of name:%n <%s>%nbut found:%n <%s>", new Object[]{this.getApplicationContext(), name, bean}));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return this;
    }

    public <T> AbstractObjectArrayAssert<?, String> getBeanNames(Class<T> type) {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto get beans names with type:%n <%s>%nbut context failed to start", new Object[]{this.getApplicationContext(), type}));
        }
        return Assertions.assertThat((Object[])this.getApplicationContext().getBeanNamesForType(type)).as("Bean names of type <%s> from <%s>", new Object[]{type, this.getApplicationContext()});
    }

    public <T> AbstractObjectAssert<?, T> getBean(Class<T> type) {
        String[] names;
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto contain bean of type:%n <%s>%nbut context failed to start", new Object[]{this.getApplicationContext(), type}));
        }
        if ((names = this.getApplicationContext().getBeanNamesForType(type)).length > 1) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nsingle bean of type:%n <%s>%nbut found:%n <%s>", new Object[]{this.getApplicationContext(), type, names}));
        }
        Object bean = names.length == 0 ? null : this.getApplicationContext().getBean(names[0], type);
        return Assertions.assertThat(bean).as("Bean of type <%s> from <%s>", new Object[]{type, this.getApplicationContext()});
    }

    public AbstractObjectAssert<?, Object> getBean(String name) {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto contain a bean of name:%n <%s>%nbut context failed to start", new Object[]{this.getApplicationContext(), name}));
        }
        Object bean = this.findBean(name);
        return Assertions.assertThat((Object)bean).as("Bean of name <%s> from <%s>", new Object[]{name, this.getApplicationContext()});
    }

    public <T> AbstractObjectAssert<?, T> getBean(String name, Class<T> type) {
        Object bean;
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto contain a bean of name:%n <%s> (%s)%nbut context failed to start", new Object[]{this.getApplicationContext(), name, type}));
        }
        if ((bean = this.findBean(name)) != null && type != null && !type.isInstance(bean)) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto contain a bean of name:%n <%s> (%s)%nbut found:%n <%s> of type <%s>", new Object[]{this.getApplicationContext(), name, type, bean, bean.getClass()}));
        }
        return Assertions.assertThat((Object)bean).as("Bean of name <%s> and type <%s> from <%s>", new Object[]{name, type, this.getApplicationContext()});
    }

    private Object findBean(String name) {
        try {
            return this.getApplicationContext().getBean(name);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    public <T> MapAssert<String, T> getBeans(Class<T> type) {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto get beans of type:%n <%s> (%s)%nbut context failed to start", new Object[]{this.getApplicationContext(), type, type}));
        }
        return (MapAssert)Assertions.assertThat((Map)this.getApplicationContext().getBeansOfType(type)).as("Beans of type <%s> from <%s>", new Object[]{type, this.getApplicationContext()});
    }

    public AbstractThrowableAssert<?, ? extends Throwable> getFailure() {
        this.hasFailed();
        return Assertions.assertThat((Throwable)this.startupFailure);
    }

    public ApplicationContextAssert<C> hasFailed() {
        if (this.startupFailure == null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have failed%nbut context started successfully", new Object[]{this.getApplicationContext()}));
        }
        return this;
    }

    public ApplicationContextAssert<C> hasNotFailed() {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have not failed:%nbut context failed to start", new Object[]{this.getApplicationContext()}));
        }
        return this;
    }

    protected final C getApplicationContext() {
        return (C)((ApplicationContext)this.actual);
    }

    protected final Throwable getStartupFailure() {
        return this.startupFailure;
    }
}

