/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.test.context.ReactiveWebMergedContextConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.web.SpringBootMockServletContext;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext;
import org.springframework.boot.web.servlet.support.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoaderUtils;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class SpringBootContextLoader
extends AbstractContextLoader {
    public ApplicationContext loadContext(MergedContextConfiguration config) throws Exception {
        Object[] configClasses = config.getClasses();
        Object[] configLocations = config.getLocations();
        Assert.state((!ObjectUtils.isEmpty((Object[])configClasses) || !ObjectUtils.isEmpty((Object[])configLocations) ? 1 : 0) != 0, () -> "No configuration classes or locations found in @SpringApplicationConfiguration. For default configuration detection to work you need Spring 4.0.3 or better (found " + SpringVersion.getVersion() + ").");
        SpringApplication application = this.getSpringApplication();
        application.setMainApplicationClass(config.getTestClass());
        application.addPrimarySources(Arrays.asList(configClasses));
        application.getSources().addAll(Arrays.asList(configLocations));
        ConfigurableEnvironment environment = this.getEnvironment();
        if (!ObjectUtils.isEmpty((Object[])config.getActiveProfiles())) {
            this.setActiveProfiles(environment, config.getActiveProfiles());
        }
        ResourceLoader resourceLoader = application.getResourceLoader() != null ? application.getResourceLoader() : new DefaultResourceLoader(((Object)((Object)this)).getClass().getClassLoader());
        TestPropertySourceUtils.addPropertiesFilesToEnvironment((ConfigurableEnvironment)environment, (ResourceLoader)resourceLoader, (String[])config.getPropertySourceLocations());
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment((ConfigurableEnvironment)environment, (String[])this.getInlinedProperties(config));
        application.setEnvironment(environment);
        List<ApplicationContextInitializer<?>> initializers = this.getInitializers(config, application);
        if (config instanceof WebMergedContextConfiguration) {
            application.setWebApplicationType(WebApplicationType.SERVLET);
            if (!this.isEmbeddedWebEnvironment(config)) {
                new WebConfigurer().configure(config, application, initializers);
            }
        } else if (config instanceof ReactiveWebMergedContextConfiguration) {
            application.setWebApplicationType(WebApplicationType.REACTIVE);
            if (!this.isEmbeddedWebEnvironment(config)) {
                new ReactiveWebConfigurer().configure(application);
            }
        } else {
            application.setWebApplicationType(WebApplicationType.NONE);
        }
        application.setInitializers(initializers);
        return application.run(this.getArgs(config));
    }

    protected SpringApplication getSpringApplication() {
        return new SpringApplication(new Class[0]);
    }

    protected ConfigurableEnvironment getEnvironment() {
        return new StandardEnvironment();
    }

    protected String[] getArgs(MergedContextConfiguration config) {
        SpringBootTest annotation = (SpringBootTest)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)config.getTestClass(), SpringBootTest.class);
        return annotation != null ? annotation.args() : new String[]{};
    }

    private void setActiveProfiles(ConfigurableEnvironment environment, String[] profiles) {
        TestPropertyValues.of("spring.profiles.active=" + StringUtils.arrayToCommaDelimitedString((Object[])profiles)).applyTo(environment);
    }

    protected String[] getInlinedProperties(MergedContextConfiguration config) {
        ArrayList<String> properties = new ArrayList<String>();
        this.disableJmx(properties);
        properties.addAll(Arrays.asList(config.getPropertySourceProperties()));
        if (!this.isEmbeddedWebEnvironment(config) && !this.hasCustomServerPort(properties)) {
            properties.add("server.port=-1");
        }
        return StringUtils.toStringArray(properties);
    }

    private void disableJmx(List<String> properties) {
        properties.add("spring.jmx.enabled=false");
    }

    private boolean hasCustomServerPort(List<String> properties) {
        Binder binder = new Binder(new ConfigurationPropertySource[]{this.convertToConfigurationPropertySource(properties)});
        return binder.bind("server.port", Bindable.of(String.class)).isBound();
    }

    private ConfigurationPropertySource convertToConfigurationPropertySource(List<String> properties) {
        return new MapConfigurationPropertySource(TestPropertySourceUtils.convertInlinedPropertiesToMap((String[])StringUtils.toStringArray(properties)));
    }

    protected List<ApplicationContextInitializer<?>> getInitializers(MergedContextConfiguration config, SpringApplication application) {
        ArrayList initializers = new ArrayList();
        for (ContextCustomizer contextCustomizer : config.getContextCustomizers()) {
            initializers.add(new ContextCustomizerAdapter(contextCustomizer, config));
        }
        initializers.addAll(application.getInitializers());
        for (Class initializerClass : config.getContextInitializerClasses()) {
            initializers.add((ApplicationContextInitializer<?>)BeanUtils.instantiateClass((Class)initializerClass));
        }
        if (config.getParent() != null) {
            initializers.add(new ParentContextApplicationContextInitializer(config.getParentApplicationContext()));
        }
        return initializers;
    }

    private boolean isEmbeddedWebEnvironment(MergedContextConfiguration config) {
        SpringBootTest annotation = (SpringBootTest)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)config.getTestClass(), SpringBootTest.class);
        return annotation != null && annotation.webEnvironment().isEmbedded();
    }

    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        super.processContextConfiguration(configAttributes);
        if (!configAttributes.hasResources()) {
            Class[] defaultConfigClasses = this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass());
            configAttributes.setClasses(defaultConfigClasses);
        }
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        return AnnotationConfigContextLoaderUtils.detectDefaultConfigurationClasses(declaringClass);
    }

    public ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("SpringApplicationContextLoader does not support the loadContext(String...) method");
    }

    protected String[] getResourceSuffixes() {
        return new String[]{"-context.xml", "Context.groovy"};
    }

    protected String getResourceSuffix() {
        throw new IllegalStateException();
    }

    @Order(value=-2147483648)
    private static class ParentContextApplicationContextInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ApplicationContext parent;

        ParentContextApplicationContextInitializer(ApplicationContext parent) {
            this.parent = parent;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            applicationContext.setParent(this.parent);
        }
    }

    private static class ContextCustomizerAdapter
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ContextCustomizer contextCustomizer;
        private final MergedContextConfiguration config;

        ContextCustomizerAdapter(ContextCustomizer contextCustomizer, MergedContextConfiguration config) {
            this.contextCustomizer = contextCustomizer;
            this.config = config;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            this.contextCustomizer.customizeContext(applicationContext, this.config);
        }
    }

    private static class ReactiveWebConfigurer {
        private static final Class<GenericReactiveWebApplicationContext> WEB_CONTEXT_CLASS = GenericReactiveWebApplicationContext.class;

        private ReactiveWebConfigurer() {
        }

        void configure(SpringApplication application) {
            application.setApplicationContextClass(WEB_CONTEXT_CLASS);
        }
    }

    private static class WebConfigurer {
        private static final Class<GenericWebApplicationContext> WEB_CONTEXT_CLASS = GenericWebApplicationContext.class;

        private WebConfigurer() {
        }

        void configure(MergedContextConfiguration configuration, SpringApplication application, List<ApplicationContextInitializer<?>> initializers) {
            WebMergedContextConfiguration webConfiguration = (WebMergedContextConfiguration)configuration;
            this.addMockServletContext(initializers, webConfiguration);
            application.setApplicationContextClass(WEB_CONTEXT_CLASS);
        }

        private void addMockServletContext(List<ApplicationContextInitializer<?>> initializers, WebMergedContextConfiguration webConfiguration) {
            SpringBootMockServletContext servletContext = new SpringBootMockServletContext(webConfiguration.getResourceBasePath());
            initializers.add(0, (ApplicationContextInitializer<?>)new ServletContextApplicationContextInitializer((ServletContext)servletContext, true));
        }
    }
}

